/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.schema.impl.XSBase64BinaryImpl;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.CryptoBinary;
import org.slf4j.Logger;

public class CryptoBinaryImpl
extends XSBase64BinaryImpl
implements CryptoBinary {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CryptoBinaryImpl.class);
    @Nullable
    private BigInteger bigIntValue;

    protected CryptoBinaryImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public BigInteger getValueBigInt() {
        if (this.bigIntValue == null) {
            try {
                String value = this.getValue();
                if (!Strings.isNullOrEmpty((String)this.getValue())) {
                    assert (value != null);
                    this.bigIntValue = KeyInfoSupport.decodeBigIntegerFromCryptoBinary(value);
                }
            }
            catch (DecodingException e) {
                this.log.warn("Could not decode big integer value, returning cached value", (Throwable)e);
            }
        }
        return this.bigIntValue;
    }

    @Override
    public void setValueBigInt(@Nullable BigInteger bigInt) throws EncodingException {
        if (bigInt == null) {
            this.setValue(null);
        } else {
            this.setValue(KeyInfoSupport.encodeCryptoBinaryFromBigInteger(bigInt));
        }
        this.bigIntValue = bigInt;
    }

    @Override
    public void setValue(@Nullable String newValue) {
        if (!(this.bigIntValue == null || Objects.equals(this.getValue(), newValue) && newValue != null)) {
            this.bigIntValue = null;
        }
        super.setValue(newValue);
    }
}

