/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.function.Consumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.core.action.ActionListener;

public interface RejectAwareActionListener<T>
extends ActionListener<T> {
    public void onRejection(Exception var1);

    public static <X> RejectAwareActionListener<X> withResponseHandler(final RejectAwareActionListener<?> errorDelegate, final Consumer<X> responseHandler) {
        return new RejectAwareActionListener<X>(){

            @Override
            public void onRejection(Exception e) {
                errorDelegate.onRejection(e);
            }

            public void onResponse(X t) {
                responseHandler.accept(t);
            }

            public void onFailure(Exception e) {
                errorDelegate.onFailure(e);
            }
        };
    }

    public static <Response> RejectAwareActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure, final Consumer<Exception> onRejection) {
        return new RejectAwareActionListener<Response>(){

            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                onFailure.accept(e);
            }

            @Override
            public void onRejection(Exception e) {
                onRejection.accept(e);
            }
        };
    }
}

