/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ExperimentalBufferPools {
    private static final AttributeKey<String> JVM_BUFFER_POOL_NAME = AttributeKey.stringKey((String)"jvm.buffer.pool.name");

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        List<BufferPoolMXBean> bufferBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        return ExperimentalBufferPools.registerObservers(openTelemetry, bufferBeans);
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<BufferPoolMXBean> bufferBeans) {
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.buffer.memory.usage").setDescription("Measure of memory used by buffers.").setUnit("By").buildWithCallback(ExperimentalBufferPools.callback(bufferBeans, BufferPoolMXBean::getMemoryUsed)));
        observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.buffer.memory.limit").setDescription("Measure of total memory capacity of buffers.").setUnit("By").buildWithCallback(ExperimentalBufferPools.callback(bufferBeans, BufferPoolMXBean::getTotalCapacity)));
        observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.buffer.count").setDescription("Number of buffers in the pool.").setUnit("{buffer}").buildWithCallback(ExperimentalBufferPools.callback(bufferBeans, BufferPoolMXBean::getCount)));
        return observables;
    }

    static Consumer<ObservableLongMeasurement> callback(List<BufferPoolMXBean> bufferPools, Function<BufferPoolMXBean, Long> extractor) {
        ArrayList<Attributes> attributeSets = new ArrayList<Attributes>(bufferPools.size());
        for (BufferPoolMXBean pool : bufferPools) {
            attributeSets.add(Attributes.builder().put(JVM_BUFFER_POOL_NAME, (Object)pool.getName()).build());
        }
        return measurement -> {
            for (int i = 0; i < bufferPools.size(); ++i) {
                Attributes attributes = (Attributes)attributeSets.get(i);
                long value = (Long)extractor.apply((BufferPoolMXBean)bufferPools.get(i));
                if (value == -1L) continue;
                measurement.record(value, attributes);
            }
        };
    }

    private ExperimentalBufferPools() {
    }
}

