/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerValidatorCallbackHandler.class);
    private CloseableVerificationKeyResolver verificationKeyResolver;
    private JwtValidator jwtValidator;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.jwtValidator = ConfigurationUtils.getConfiguredInstance(configs, saslMechanism, jaasConfigEntries, "sasl.oauthbearer.jwt.validator.class", JwtValidator.class);
    }

    void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries, CloseableVerificationKeyResolver verificationKeyResolver, JwtValidator jwtValidator) {
        this.verificationKeyResolver = verificationKeyResolver;
        this.verificationKeyResolver.configure(configs, saslMechanism, jaasConfigEntries);
        this.jwtValidator = jwtValidator;
        this.jwtValidator.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.jwtValidator, "JWT validator");
        Utils.closeQuietly(this.verificationKeyResolver, "JWT verification key resolver");
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.checkConfigured();
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                this.handleValidatorCallback((OAuthBearerValidatorCallback)callback);
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                this.handleExtensionsValidatorCallback((OAuthBearerExtensionsValidatorCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleValidatorCallback(OAuthBearerValidatorCallback callback) {
        this.checkConfigured();
        try {
            OAuthBearerToken token = this.jwtValidator.validate(callback.tokenValue());
            callback.token(token);
        }
        catch (JwtValidatorException e) {
            log.warn(e.getMessage(), (Throwable)e);
            callback.error("invalid_token", null, null);
        }
    }

    private void handleExtensionsValidatorCallback(OAuthBearerExtensionsValidatorCallback extensionsValidatorCallback) {
        this.checkConfigured();
        extensionsValidatorCallback.inputExtensions().map().forEach((extensionName, v) -> extensionsValidatorCallback.valid((String)extensionName));
    }

    private void checkConfigured() {
        if (this.jwtValidator == null) {
            throw new IllegalStateException(String.format("To use %s, first call the configure method", this.getClass().getSimpleName()));
        }
    }
}

