/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class UniformRandomPayloadGenerator
implements PayloadGenerator {
    private final int size;
    private final long seed;
    private final int padding;
    private final Random random = new Random();
    private final byte[] padBytes;
    private final byte[] randomBytes;

    @JsonCreator
    public UniformRandomPayloadGenerator(@JsonProperty(value="size") int size, @JsonProperty(value="seed") long seed, @JsonProperty(value="padding") int padding) {
        this.size = size;
        this.seed = seed;
        this.padding = padding;
        if (padding < 0 || padding > size) {
            throw new RuntimeException("Invalid value " + padding + " for padding: the number of padding bytes must not be smaller than 0 or greater than the total payload size.");
        }
        this.padBytes = new byte[padding];
        this.random.setSeed(seed);
        this.random.nextBytes(this.padBytes);
        this.randomBytes = new byte[size - padding];
    }

    @JsonProperty
    public int size() {
        return this.size;
    }

    @JsonProperty
    public long seed() {
        return this.seed;
    }

    @JsonProperty
    public int padding() {
        return this.padding;
    }

    @Override
    public synchronized byte[] generate(long position) {
        byte[] result = new byte[this.size];
        if (this.randomBytes.length > 0) {
            this.random.setSeed(this.seed + position);
            this.random.nextBytes(this.randomBytes);
            System.arraycopy(this.randomBytes, 0, result, 0, Math.min(this.randomBytes.length, result.length));
        }
        if (this.padBytes.length > 0) {
            System.arraycopy(this.padBytes, 0, result, this.randomBytes.length, result.length - this.randomBytes.length);
        }
        return result;
    }
}

