/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.undo;

import java.util.LinkedList;
import java.util.ListIterator;
import org.freeplane.core.undo.IActor;

public class CompoundActor
implements IActor {
    private final LinkedList<IActor> actors;

    public CompoundActor() {
        this(new LinkedList());
    }

    public CompoundActor(LinkedList<? extends IActor> actors) {
        this.actors = actors;
    }

    @Override
    public void act() {
        for (IActor a : this.actors) {
            a.act();
        }
    }

    public void add(IActor firstActor) {
        this.actors.add(firstActor);
    }

    @Override
    public String getDescription() {
        if (this.actors.size() == 0) {
            return "";
        }
        String firstDescription = this.actors.getFirst().getDescription();
        if (this.actors.size() == 1) {
            return firstDescription;
        }
        String lastDescription = this.actors.getLast().getDescription();
        if (this.actors.size() == 2 && !firstDescription.equals("") && !lastDescription.equals("")) {
            return firstDescription + ", " + lastDescription;
        }
        return firstDescription + "... " + lastDescription;
    }

    @Override
    public void undo() {
        ListIterator<IActor> iterator = this.actors.listIterator(this.actors.size());
        while (iterator.hasPrevious()) {
            iterator.previous().undo();
        }
    }

    public boolean isEmpty() {
        return this.actors.size() == 0;
    }
}

