/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.jkiss.dbeaver.Log;

public class SQLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private static final Log log = Log.getLog(SQLDoubleClickStrategy.class);
    protected ITextViewer fText;
    protected int curPos;
    protected int startPos;
    protected int endPos;
    protected static char[] fgBrackets = new char[]{'(', ')', '[', ']', '\'', '\'', '\"', '\"'};

    public void doubleClicked(ITextViewer viewer) {
        this.fText = viewer;
        this.curPos = viewer.getSelectedRange().x;
        if (this.curPos < 0 || this.curPos >= this.fText.getDocument().getLength()) {
            return;
        }
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchBracketsAt() {
        if (this.curPos == 0) {
            return false;
        }
        int bracketIndex1 = fgBrackets.length;
        int bracketIndex2 = fgBrackets.length;
        this.startPos = -1;
        this.endPos = -1;
        try {
            IDocument doc = this.fText.getDocument();
            char prevChar = doc.getChar(this.curPos - 1);
            char nextChar = doc.getChar(this.curPos);
            int i = 0;
            while (i < fgBrackets.length) {
                if (prevChar == fgBrackets[i]) {
                    this.startPos = this.curPos - 1;
                    bracketIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < fgBrackets.length) {
                if (nextChar == fgBrackets[i]) {
                    this.endPos = this.curPos;
                    bracketIndex2 = i;
                }
                i += 2;
            }
            if (this.startPos > -1 && bracketIndex1 < bracketIndex2) {
                this.endPos = this.searchForClosingBracket(this.startPos, prevChar, fgBrackets[bracketIndex1 + 1], doc);
                if (this.endPos > -1) {
                    return true;
                }
                this.startPos = -1;
                return false;
            }
            if (this.endPos <= -1) return false;
            this.startPos = this.searchForOpenBracket(this.endPos, fgBrackets[bracketIndex2 - 1], nextChar, doc);
            if (this.startPos > -1) {
                return true;
            }
            this.endPos = -1;
            return false;
        }
        catch (BadLocationException x) {
            log.debug((Object)x);
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = this.curPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            this.startPos = pos;
            pos = this.curPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            this.endPos = pos;
            return true;
        }
        catch (BadLocationException x) {
            log.debug((Object)x);
            return false;
        }
    }

    protected int searchForClosingBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int stack = 1;
        int closePosition = startPosition + 1;
        int length = document.getLength();
        while (closePosition < length && stack > 0) {
            char nextChar = document.getChar(closePosition);
            if (nextChar == openBracket && nextChar != closeBracket) {
                ++stack;
            } else if (nextChar == closeBracket) {
                --stack;
            }
            ++closePosition;
        }
        if (stack == 0) {
            return closePosition - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int stack = 1;
        int openPos = startPosition - 1;
        while (openPos >= 0 && stack > 0) {
            char nextChar = document.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
            } else if (nextChar == openBracket) {
                --stack;
            }
            --openPos;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.startPos == this.endPos) {
                this.fText.setSelectedRange(this.startPos, 0);
            } else {
                this.fText.setSelectedRange(this.startPos + 1, this.endPos - this.startPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.startPos == this.endPos) {
                this.fText.setSelectedRange(this.startPos, 0);
            } else {
                this.fText.setSelectedRange(this.startPos + 1, this.endPos - this.startPos - 1);
            }
        }
    }
}

