﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune-graph/NeptuneGraph_EXPORTS.h>
#include <aws/neptune-graph/model/GraphStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace NeptuneGraph {
namespace Model {

/**
 * <p>Summary details about a graph.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GraphSummary">AWS
 * API Reference</a></p>
 */
class GraphSummary {
 public:
  AWS_NEPTUNEGRAPH_API GraphSummary() = default;
  AWS_NEPTUNEGRAPH_API GraphSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEGRAPH_API GraphSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEGRAPH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the graph.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GraphSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the graph.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GraphSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN associated with the graph.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GraphSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the graph.</p>
   */
  inline GraphStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(GraphStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GraphSummary& WithStatus(GraphStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to
   * the graph.</p>
   */
  inline int GetProvisionedMemory() const { return m_provisionedMemory; }
  inline bool ProvisionedMemoryHasBeenSet() const { return m_provisionedMemoryHasBeenSet; }
  inline void SetProvisionedMemory(int value) {
    m_provisionedMemoryHasBeenSet = true;
    m_provisionedMemory = value;
  }
  inline GraphSummary& WithProvisionedMemory(int value) {
    SetProvisionedMemory(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If <code>true</code>, the graph has a public endpoint, otherwise not.</p>
   */
  inline bool GetPublicConnectivity() const { return m_publicConnectivity; }
  inline bool PublicConnectivityHasBeenSet() const { return m_publicConnectivityHasBeenSet; }
  inline void SetPublicConnectivity(bool value) {
    m_publicConnectivityHasBeenSet = true;
    m_publicConnectivity = value;
  }
  inline GraphSummary& WithPublicConnectivity(bool value) {
    SetPublicConnectivity(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The graph endpoint.</p>
   */
  inline const Aws::String& GetEndpoint() const { return m_endpoint; }
  inline bool EndpointHasBeenSet() const { return m_endpointHasBeenSet; }
  template <typename EndpointT = Aws::String>
  void SetEndpoint(EndpointT&& value) {
    m_endpointHasBeenSet = true;
    m_endpoint = std::forward<EndpointT>(value);
  }
  template <typename EndpointT = Aws::String>
  GraphSummary& WithEndpoint(EndpointT&& value) {
    SetEndpoint(std::forward<EndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of replicas for the graph.</p>
   */
  inline int GetReplicaCount() const { return m_replicaCount; }
  inline bool ReplicaCountHasBeenSet() const { return m_replicaCountHasBeenSet; }
  inline void SetReplicaCount(int value) {
    m_replicaCountHasBeenSet = true;
    m_replicaCount = value;
  }
  inline GraphSummary& WithReplicaCount(int value) {
    SetReplicaCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the KMS key used to encrypt and decrypt graph data.</p>
   */
  inline const Aws::String& GetKmsKeyIdentifier() const { return m_kmsKeyIdentifier; }
  inline bool KmsKeyIdentifierHasBeenSet() const { return m_kmsKeyIdentifierHasBeenSet; }
  template <typename KmsKeyIdentifierT = Aws::String>
  void SetKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    m_kmsKeyIdentifierHasBeenSet = true;
    m_kmsKeyIdentifier = std::forward<KmsKeyIdentifierT>(value);
  }
  template <typename KmsKeyIdentifierT = Aws::String>
  GraphSummary& WithKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    SetKmsKeyIdentifier(std::forward<KmsKeyIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If <code>true</code>, deletion protection is enabled for the graph.</p>
   */
  inline bool GetDeletionProtection() const { return m_deletionProtection; }
  inline bool DeletionProtectionHasBeenSet() const { return m_deletionProtectionHasBeenSet; }
  inline void SetDeletionProtection(bool value) {
    m_deletionProtectionHasBeenSet = true;
    m_deletionProtection = value;
  }
  inline GraphSummary& WithDeletionProtection(bool value) {
    SetDeletionProtection(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_arn;

  GraphStatus m_status{GraphStatus::NOT_SET};

  int m_provisionedMemory{0};

  bool m_publicConnectivity{false};

  Aws::String m_endpoint;

  int m_replicaCount{0};

  Aws::String m_kmsKeyIdentifier;

  bool m_deletionProtection{false};
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_provisionedMemoryHasBeenSet = false;
  bool m_publicConnectivityHasBeenSet = false;
  bool m_endpointHasBeenSet = false;
  bool m_replicaCountHasBeenSet = false;
  bool m_kmsKeyIdentifierHasBeenSet = false;
  bool m_deletionProtectionHasBeenSet = false;
};

}  // namespace Model
}  // namespace NeptuneGraph
}  // namespace Aws
