/***************************************************************************
                          scheduleconf.cpp  -  description
                             -------------------
    begin                : Wed May 3 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          scheduleconf.cpp  -  description
                             -------------------
    begin                : Thu Mar 16 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scheduleconf.h"

ScheduleConf::ScheduleConf(QWidget *parent, const char *name )
			: QFrame(parent,name)
{
	QFont fnt(QFont("helvetica",12, QFont::Bold));

	schedBox = new QCheckBox(i18n("Schedule this project"), this);
	schedBox->setGeometry(10,20,150,15);
	schedBox->setFont(fnt);
	connect(schedBox, SIGNAL(clicked()), this, SLOT(enableSched()));

	schedOutputBox = new QCheckBox(i18n("Show output-window, when activ"), this);
	schedOutputBox->setGeometry(230,20,280,30);
	schedOutputBox->setEnabled(false);

	runGrp = new QButtonGroup(i18n("Run"), this);
	runGrp->setGeometry(20,50,150,160);
	runGrp->setEnabled(false);
	
		hourlyBut = new QRadioButton(i18n("Hourly"), runGrp);
		hourlyBut->setGeometry(5,30,100,15);
		hourlyBut->setEnabled(false);
		hourlyBut->setChecked(true);
		connect(hourlyBut, SIGNAL(clicked()), this, SLOT(setHourlyOptions()));

		dailyBut = new QRadioButton(i18n("Daily"), runGrp);
		dailyBut->setGeometry(5,60,100,15);
		dailyBut->setEnabled(false);
		connect(dailyBut, SIGNAL(clicked()), this, SLOT(setDailyOptions()));

		weeklyBut = new QRadioButton(i18n("Weekly"), runGrp);
		weeklyBut->setGeometry(5,90,100,15);
		weeklyBut->setEnabled(false);
		connect(weeklyBut, SIGNAL(clicked()), this, SLOT(setWeeklyOptions()));

		monthlyBut = new QRadioButton(i18n("Monthly"), runGrp);
		monthlyBut->setGeometry(5,120,100,15);
		monthlyBut->setEnabled(false);
		connect(monthlyBut, SIGNAL(clicked()), this, SLOT(setMonthlyOptions()));

	hourlyGrp = new QButtonGroup(i18n("Start At"), this);
	hourlyGrp->setGeometry(190,50,350,160);
	hourlyGrp->setEnabled(false);
	
	dailyGrp = new QButtonGroup(i18n("Start At"), this);
	dailyGrp->setGeometry(190,50,350,160);
	dailyGrp->setEnabled(false);
	dailyGrp->hide();

// Initlialising of the hourly, daily, weekly and monthly-options

// Needed for a hourly-schedule job
		afterHourSpBox = new QSpinBox(0,59,1,hourlyGrp);
		afterHourSpBox->setGeometry(20,20,50,20);
		afterHourSpBox->setEnabled(false);

		afterHourLab = new QLabel(i18n("Minutes after the hour"), hourlyGrp);
		afterHourLab->setGeometry(80,20,150,20);

// Needed for a daily-, weekly- and monthly-schedule job
		hourSpBox = new QSpinBox(0,13,1,dailyGrp);
		hourSpBox->setGeometry(20,20,50,20);
		hourSpBox->setValue(12);
		hourSpBox->setEnabled(false);
		connect(hourSpBox, SIGNAL(valueChanged(int)), this, SLOT(setHourBack(int)));
	
		dot = new QLabel(":", dailyGrp);
		dot->setGeometry(80,20,5,20);

		minSpBox = new QSpinBox(-1,60,1,dailyGrp);
		minSpBox->setGeometry(90,20,50,20);
		minSpBox->setEnabled(false);
		minSpBox->setValue(0);
		connect(minSpBox, SIGNAL(valueChanged(int)), this, SLOT(setMinuteBack(int)));
	
		amBut = new QRadioButton(i18n("AM"), dailyGrp);
		amBut->setGeometry(160,10,40,40);
		amBut->setEnabled(false);
		amBut->setChecked(true);

		pmBut = new QRadioButton(i18n("PM"), dailyGrp);
		pmBut->setGeometry(210,10,40,40);
		pmBut->setEnabled(false);

// Needed for a weekly-schedule job
	dayGrp = new QButtonGroup(i18n("Select days"), dailyGrp);
	dayGrp->setGeometry(10,50,330,100);
	dayGrp->setEnabled(false);

		monBut = new QCheckBox(i18n("Monday"), dayGrp);
		monBut->setGeometry(50,20,90,15);
		monBut->setEnabled(false);

		tueBut = new QCheckBox(i18n("Tuesday"), dayGrp);
		tueBut->setGeometry(50,40,90,15);
		tueBut->setEnabled(false);

		wedBut = new QCheckBox(i18n("Wednesday"), dayGrp);
		wedBut->setGeometry(50,60,90,15);
		wedBut->setEnabled(false);

		thuBut = new QCheckBox(i18n("Thursday"), dayGrp);
		thuBut->setGeometry(50,80,90,15);
		thuBut->setEnabled(false);

		friBut = new QCheckBox(i18n("Friday"), dayGrp);
		friBut->setGeometry(150,20,90,15);
		friBut->setEnabled(false);

		satBut = new QCheckBox(i18n("Saturday"), dayGrp);
		satBut->setGeometry(150,40,90,15);
		satBut->setEnabled(false);

		sunBut = new QCheckBox(i18n("Sunday"), dayGrp);
		sunBut->setGeometry(150,60,90,15);
		sunBut->setEnabled(false);

// Needed for a monthly-schedule job
		monthFrame = new QFrame(dailyGrp);
		monthFrame->setGeometry(10,50,330,100);
		
		QLabel *monthLab = new QLabel(i18n("Day of the month"), monthFrame);
		monthLab->setGeometry(5,15,100,20);
		
		monthSpBox = new QSpinBox(1,31,1, monthFrame);
		monthSpBox->setGeometry(110,15,50,20);
		monthSpBox->setEnabled(false);

	schedCountBox = new QCheckBox(i18n("Schedule project for a given number of times"), this);
	schedCountBox->setGeometry(20,220,280,20);
	schedCountBox->setEnabled(false);
	connect(schedCountBox, SIGNAL(clicked()), this, SLOT(enableCount()));

	schedCountSpBox = new QSpinBox( 1, 1000, 1, this, 0 );
	schedCountSpBox->setGeometry(300,220,50,20);
	schedCountSpBox->setEnabled(false);
}

ScheduleConf::~ScheduleConf()
{
}

void ScheduleConf::enableSched()
{
	if ( schedBox->isChecked() ){
		schedOutputBox->setEnabled(true);
		afterHourSpBox->setEnabled(true);
		runGrp->setEnabled(true);
		hourlyBut->setEnabled(true);
		dailyBut->setEnabled(true);
		weeklyBut->setEnabled(true);
		monthlyBut->setEnabled(true);
		hourlyGrp->setEnabled(true);
		dailyGrp->setEnabled(true);
		dayGrp->setEnabled(true);
		schedCountBox->setEnabled(true);
		if ( schedCountBox->isChecked())
			schedCountSpBox->setEnabled(true);
		hourSpBox->setEnabled(true);
		minSpBox->setEnabled(true);
		amBut->setEnabled(true);
		pmBut->setEnabled(true);
		monthSpBox->setEnabled(true);
		satBut->setEnabled(true);
		sunBut->setEnabled(true);
		monBut->setEnabled(true);
		tueBut->setEnabled(true);
		wedBut->setEnabled(true);
		thuBut->setEnabled(true);
		friBut->setEnabled(true);
	}else {
		schedOutputBox->setEnabled(false);
		afterHourSpBox->setEnabled(false);
		runGrp->setEnabled(false);
		hourlyBut->setEnabled(false);
		dailyBut->setEnabled(false);
		weeklyBut->setEnabled(false);
		monthlyBut->setEnabled(false);
		hourlyGrp->setEnabled(false);
		dailyGrp->setEnabled(false);
		dayGrp->setEnabled(false);
		schedCountBox->setEnabled(false);
		schedCountSpBox->setEnabled(false);
		hourSpBox->setEnabled(false);
		minSpBox->setEnabled(false);
		amBut->setEnabled(false);
		pmBut->setEnabled(false);
		monthSpBox->setEnabled(false);
		satBut->setEnabled(false);
		sunBut->setEnabled(false);
		monBut->setEnabled(false);
		tueBut->setEnabled(false);
		wedBut->setEnabled(false);
		thuBut->setEnabled(false);
		friBut->setEnabled(false);
	}
}

void ScheduleConf::enableCount()
{
	if ( schedCountBox->isChecked())
		schedCountSpBox->setEnabled(true);
	else
		schedCountSpBox->setEnabled(false);
}

void ScheduleConf::setHourBack(int val)
{
	if ( val == 13 )
		hourSpBox->setValue(1);
	if ( val == 0)
		hourSpBox->setValue(12);
}

void ScheduleConf::setMinuteBack(int val)
{
	if ( val == 60 )
		minSpBox->setValue(0);
	if ( val == -1 )
		minSpBox->setValue(59);
}

void ScheduleConf::setHourlyOptions()
{
	dailyGrp->hide();
	hourlyGrp->show();
}

void ScheduleConf::setDailyOptions()
{
	hourlyGrp->hide();
	dayGrp->hide();
	monthFrame->hide();
	dailyGrp->show();
}

void ScheduleConf::setWeeklyOptions()
{
	hourlyGrp->hide();
	dayGrp->show();
	monthFrame->hide();
	dailyGrp->show();
}

void ScheduleConf::setMonthlyOptions()
{
	hourlyGrp->hide();
	dayGrp->hide();
	dailyGrp->show();
	monthFrame->show();
}
