/***************************************************************************
                          kscheduleicon.cpp  -  description
                             -------------------
    begin                : Sat Mar 18 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kscheduleicon.h"

#include "../pics/active.xpm"
#include "../pics/inactive.xpm"

KScheduleIcon::KScheduleIcon(QWidget *parent, const char *name )
			 : QWidget(parent,name)
{
    KWM::setDockWindow(this->winId());

	schedPop = new KPopupMenu("KWebGet");
    menupunkt[0] = schedPop->insertItem(i18n("Stop Scheduler"));
    menupunkt[1] = schedPop->insertItem(i18n("Information"));
    menupunkt[2] = schedPop->insertItem(i18n("Show Output"));
    schedPop->insertSeparator();
}

KScheduleIcon::~KScheduleIcon()
{
}

void KScheduleIcon::mouseReleaseEvent (QMouseEvent *e) {
    if (e->button() == RightButton) {
	QPoint mPnt;
	mPnt = mapToGlobal(QPoint(this->x()-250, this->y()-260));
	schedPop->popup(mPnt,0);
	schedPop->exec();
    }
}

void KScheduleIcon::setActive(bool state)
{
	if ( state ) {
		st = state;
		this->repaint();
	} else {
		st = state;
		this->repaint();
	}
}

void KScheduleIcon::paintEvent(QPaintEvent *)
{
	p = new QPainter;
	p->begin(this);
	p->setWindow(2, 2, 22, 22);
	if ( st ) {
		p->drawPixmap(0,4, QPixmap((const char**)active));
	} else {
		p->drawPixmap(0,4, QPixmap((const char**)inactive));
	}
    p->end();
}