/******************************************************************************
 * Copyright (C) 2008 Peter ZHOU <peterzhoulei@gmail.com>                     *
 *                                                                            *
 * This program is free software; you can redistribute it and/or              *
 * modify it under the terms of the GNU General Public License as             *
 * published by the Free Software Foundation; either version 2 of             *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License          *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.      *
 ******************************************************************************/

#ifndef SCRIPT_IMPORTER_H
#define SCRIPT_IMPORTER_H

#include <KUrl>

#include <QObject>
#include <QtScript>

namespace Amarok
{

    class ScriptImporter : public QObject
    {
        Q_OBJECT

        public:
            ScriptImporter( QScriptEngine* ScriptEngine, KUrl url );
            ~ScriptImporter();

        public slots:
            void load( QString src );
            void loadQtBinding( QString binding );

        private:
            KUrl m_URL;
            QScriptEngine*  m_ScriptEngine;
    };
}

#endif
