/*
    SPDX-FileCopyrightText: 2008 Nicola Gigante <nicola.gigante@gmail.com>
    SPDX-FileCopyrightText: 2020 Harald Sitter <sitter@kde.org>

    SPDX-License-Identifier: LGPL-2.1-or-later
*/

#ifndef HELPER_PROXY_H
#define HELPER_PROXY_H

#include <QObject>
#include <QMap>
#include <QString>
#include <QVariant>

#include "kauthaction.h"
#include "kauthactionreply.h"

namespace KAuth
{

typedef Action::DetailsMap DetailsMap;

class HelperProxy : public QObject
{
    Q_OBJECT

public:
    virtual ~HelperProxy();

    // Application-side methods
    virtual void executeAction(const QString &action, const QString &helperID,
                               const DetailsMap &details, const QVariantMap &arguments,
                               int timeout) = 0;
    virtual void stopAction(const QString &action, const QString &helperID) = 0;

    // Helper-side methods
    virtual bool initHelper(const QString &name) = 0;
    virtual void setHelperResponder(QObject *o) = 0;
    virtual bool hasToStopAction() = 0;
    virtual void sendDebugMessage(int level, const char *msg) = 0;
    virtual void sendProgressStep(int step) = 0;
    virtual void sendProgressStep(const QVariantMap &step) = 0;
    // Attempts to resolve the UID of the unprivileged remote process.
    virtual int callerUid() const = 0;

Q_SIGNALS:
    void actionStarted(const QString &action);
    void actionPerformed(const QString &action, const KAuth::ActionReply &reply);
    void progressStep(const QString &action, int progress);
    void progressStep(const QString &action, const QVariantMap &data);
};

} // namespace KAuth

Q_DECLARE_INTERFACE(KAuth::HelperProxy, "org.kde.kf5auth.HelperProxy/0.1")

#endif
