/***************************************************************************
                          basicdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BASICDLG_H
#define BASICDLG_H

#include <qdialog.h>
#include "kplnamespace.h"

class QComboBox;
class KColorButton;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Basic settings dialog class. Provides a dialog for the
  * presettings for page size and colors.
  * @author Werner Stille
  */
class BasicDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param bs pointer to autoplot settings structure.
   */
  BasicDlg(QWidget* parent, Kpl::AutoStruct* bs);
  /** Destructor. */
  ~BasicDlg();

protected:
  Kpl::AutoStruct* b;
  QComboBox* pres;
  KplSpinBox* prec;
  KplDoubleEdit *formatx, *formaty;
  KColorButton *colFrame, *colGrid, *colData;

protected slots:
  /** Sets page size to A4 portrait. */
  void slotPortrait();
  /** Sets page size to A4 landscape. */
  void slotLandscape();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Displays help for the basic settings dialog. */
  void slotHelp();
};

#endif
