/*
 * Decompiled with CFR 0.152.
 */
package classycle.classfile;

import classycle.classfile.Constant;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class ConstantPoolPrinter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java classycle.classfile.ConstantPoolPrinter <class files>");
        }
        for (int i = 0; i < args.length; ++i) {
            ConstantPoolPrinter.investigate(args[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void investigate(String fileName) {
        FilterInputStream stream = null;
        try {
            stream = new DataInputStream(new FileInputStream(fileName));
            Constant[] pool = Constant.extractConstantPool((DataInputStream)stream);
            ConstantPoolPrinter.printConstantPool(pool);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void printConstantPool(Constant[] pool) {
        for (int i = 0; i < pool.length; ++i) {
            System.out.println(i + ": " + pool[i]);
        }
    }
}

