/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-*/
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef AVCBox_h_
#define AVCBox_h_

#include "nsTArray.h"
#include "nsAutoPtr.h"
#include "ISOMediaBoxes.h"

namespace mozilla {

class ISOControl;

// 14496-12 8.5.2.2
#define resolution_72_dpi 0x00480000
#define video_depth 0x0018

// 14496-15 5.3.4.1 'Sample description name and format'
// Box type: 'avcC'
class AVCConfigurationBox : public Box {
public:
  // ISO BMFF members

  // avcConfig is CodecSpecificData from 14496-15 '5.3.4.1 Sample description
  // name and format.
  // These data are generated by encoder and we encapsulated the generated
  // bitstream into box directly.
  nsTArray<uint8_t> avcConfig;

  // MuxerOperation methods
  nsresult Generate(uint32_t* aBoxSize) override;
  nsresult Write() override;

  // AVCConfigurationBox methods
  AVCConfigurationBox(ISOControl* aControl);
  ~AVCConfigurationBox();
};

// 14496-15 5.3.4.1 'Sample description name and format'
// Box type: 'avc1'
class AVCSampleEntry : public VisualSampleEntry {
public:
  // ISO BMFF members
  nsRefPtr<AVCConfigurationBox> avcConfigBox;

  // MuxerOperation methods
  nsresult Generate(uint32_t* aBoxSize) override;
  nsresult Write() override;

  // VisualSampleEntry methods
  AVCSampleEntry(ISOControl* aControl);
  ~AVCSampleEntry();
};

}

#endif // AVCBox_h_
