/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IOTest
extends AbstractTest {
    public IOTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new IOTest("readLib1"));
        list.add(new IOTest("readLib2"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/IO/output/";
    }

    public boolean readLib1() {
        return IOTest.ioReadGenStatic(this.getRegressionPath(), "/data/qThree", "qThreeTop.jelib", "qThreeTop", 365, 0, 0);
    }

    public boolean readLib2() {
        return IOTest.ioReadGenStatic(this.getRegressionPath(), "/data/muddChip", "MIPS.jelib", "chip", 0, 3879, 0);
    }

    public static boolean ioReadGenStatic(String trueRootPath, String libPath, String libName, String logFile, int expectedNumInputLogs, int expectedNumNetworkLogs, int expectedNumCheckErrors) {
        boolean passed = false;
        try {
            String testParameter = IOTest.properDirectory(trueRootPath, IOTest.class);
            String outputDir = IOTest.outputDir(trueRootPath, testParameter);
            IOTest.ensureOutputDirectory(outputDir);
            MessagesStream.getMessagesStream().save(outputDir + logFile + ".log");
            IOTest.setFoundry(Technology.getMocmosTechnology(), "Mosis");
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            NetworkTool.totalNumErrors = 0;
            IOTest.wipeLibraries();
            LayoutLib.openLibForRead(trueRootPath + libPath + "/" + libName, ep, true);
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                Iterator<Cell> cit = lib.getCells();
                while (cit.hasNext()) {
                    Cell cell = cit.next();
                    cell.getNetlist();
                }
            }
            int numInputLogs = Input.errorLogger.getNumLogs();
            int numNetworkLogs = NetworkTool.totalNumErrors;
            int numCheckErrors = 0;
            Iterator<Library> it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library lib = it2.next();
                numCheckErrors += lib.checkAndRepair(false, ErrorLogger.newInst("Check Libraries"), ep);
            }
            boolean bl = passed = expectedNumInputLogs == numInputLogs && expectedNumNetworkLogs == numNetworkLogs && expectedNumCheckErrors == numCheckErrors;
            if (!passed) {
                System.out.println("ERROR: Expected " + expectedNumInputLogs + " input " + expectedNumNetworkLogs + " network " + expectedNumCheckErrors + " errors");
                System.out.println("   but obtained " + numInputLogs + " input " + numNetworkLogs + " network " + numCheckErrors + " errors");
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
        return passed;
    }
}

