/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gnome.DruidPage} widget.
 */
public class DruidPageSetupEvent extends GtkEvent {
	/**
	 * Type of a DruidPageSetupEvent
	 */
	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		public static final Type PREPARE = new Type(1, "PREPARE");
		public static final Type FINISH = new Type(2, "FINISH");
		
	}

	
	/**
	 * Creates a new DruidPageEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public DruidPageSetupEvent(Object source, DruidPageSetupEvent.Type type) {
		super(source, type);
	}
	
	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DruidPageSetupEvent.Type aType){
		return ( type.getID() == aType.getID());
	}

}
