/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:54 EDT
 */

package org.gnu.gnome;
import org.gnu.gdk.Color;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
import org.gnu.gtk.Widget;
/**
 * A widget representing pages that are not initial or terminal pages of a Druid.
 */
public class DruidPageStandard extends DruidPage {
	/**
	 * Construct a new DruidPageStandard object
	 */
	public DruidPageStandard() {
		handle = gnome_druid_page_standard_new();
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new DruidPageStandard object
	 */
	public DruidPageStandard(String title, Pixbuf logo, Pixbuf topWatermark) {
		handle = gnome_druid_page_standard_new_with_vals(title, logo.getHandle(), topWatermark.getHandle());
		initializeEventHandlers();
	}
	
	/**
	 * Constructs a new DruidPageStandard object form a native resource.
	 * @param handle The handle to the native resource.
	 */
	public DruidPageStandard(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
	}

	/**
	 * Set the title for the page.
	 */
	public void setTitle(String title) {
		gnome_druid_page_standard_set_title(handle, title);
	}
	
	/**
	 * Set the logo for the page.
	 */
	public void setLogo(Pixbuf logo) {
		gnome_druid_page_standard_set_logo(handle, logo.getHandle());
	}
	
	/**
	 * Set the watermark for the page.
	 */
	public void setTopWatermark(Pixbuf watermark) {
		gnome_druid_page_standard_set_top_watermark(handle, watermark.getHandle());
	}
	
	/**
	 * Set the title foreground for the page.
	 */
	public void setTitleForegroundColor(Color color) {
		gnome_druid_page_standard_set_title_foreground(handle, color.getHandle());
	}
	
	/**
	 * Set the background for the page.
	 */
	public void setBackgroundColor(Color color) {
		gnome_druid_page_standard_set_background(handle, color.getHandle());
	}
	
	/**
	 * Set the logo background color.
	 */
	public void setLogoBackgroundColor(Color color) {
		gnome_druid_page_standard_set_logo_background(handle, color.getHandle());
	}
	
	/**
	 * Set the contents background for the page.
	 */
	public void setContentsBackgroundColor(Color color) {
		gnome_druid_page_standard_set_contents_background(handle, color.getHandle());
	}
	
	/**
	 * Get the layout control for the page.  This can be used to add widgets
	 * the the main area of the page.
	 */
	public VBox getLayout() {
		return new VBox(DruidPageStandard.getVbox(handle));
	}
	
	/**
	 * Convenience method to append a widget.
	 */
	public void appendItem(String question, Widget item, String additionalInfo) {
		gnome_druid_page_standard_append_item(handle, question, item.getHandle(), additionalInfo);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_druid_page_standard_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getVbox(int cptr);
	native static final protected String getTitle(int cptr);
	native static final protected int getLogo(int cptr);
	native static final protected int getTopWatermark(int cptr);
	native static final protected int getTitleForeground(int cptr);
	native static final protected int getBackground(int cptr);
	native static final protected int getLogoBackground(int cptr);
	native static final protected int getContentsBackground(int cptr);
	native static final protected int gnome_druid_page_standard_get_type();
	native static final protected int gnome_druid_page_standard_new();
	native static final protected int gnome_druid_page_standard_new_with_vals(String title, int logo, int topWatermark);
	native static final protected void gnome_druid_page_standard_set_title(int page, String title);
	native static final protected void gnome_druid_page_standard_set_logo(int page, int logoImage);
	native static final protected void gnome_druid_page_standard_set_top_watermark(int page, int topWatermarkImage);
	native static final protected void gnome_druid_page_standard_set_title_foreground(int page, int color);
	native static final protected void gnome_druid_page_standard_set_background(int page, int color);
	native static final protected void gnome_druid_page_standard_set_logo_background(int page, int color);
	native static final protected void gnome_druid_page_standard_set_contents_background(int page, int color);
	native static final protected void gnome_druid_page_standard_append_item(int page, String questionMnemonic, int item, String additionalInfoMarkup);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
