// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTBUFFER_H
#define _GTKMM_TEXTBUFFER_H

#include <glibmm.h>

/* $Id: textbuffer.hg,v 1.39 2002/12/30 16:56:25 daniel Exp $ */

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/object.h>
#include <gtkmm/texttagtable.h>
#include <gtkmm/textchildanchor.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>
#include <gtkmm/clipboard.h>
#include <gdkmm/pixbuf.h>
#include <gtkmmconfig.h>
#include <utility>

GTKMM_USING_STD(pair)


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextBuffer GtkTextBuffer;
typedef struct _GtkTextBufferClass GtkTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextBuffer_Class; } // namespace Gtk
namespace Gtk
{

class TextMark;
class TextIter;

/** Multi-line text that can be displayed by one or more Gtk::TextView widgets.
 * @ingroup TextView
 */

class TextBuffer : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TextBuffer CppObjectType;
  typedef TextBuffer_Class CppClassType;
  typedef GtkTextBuffer BaseObjectType;
  typedef GtkTextBufferClass BaseClassType;

private:  friend class TextBuffer_Class;
  static CppClassType textbuffer_class_;

private:
  // noncopyable
  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&);

protected:
  explicit TextBuffer(const Glib::ConstructParams& construct_params);
  explicit TextBuffer(GtkTextBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTextBuffer*       gobj()       { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTextBuffer* gobj() const { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  GtkTextBuffer* gobj_copy();

private:

   
public:
  typedef TextIter iterator;
  typedef TextTag Tag;
  typedef TextTagTable TagTable;
  typedef TextMark Mark;

protected:
  TextBuffer();
  explicit TextBuffer(const Glib::RefPtr<TagTable>& tag_table);

public:
  
  static Glib::RefPtr<TextBuffer> create();

  
  static Glib::RefPtr<TextBuffer> create(const Glib::RefPtr<TagTable>& tag_table);


  /** Obtains the number of lines in the buffer. This value is cached, so
   * the function is very fast.
   * @return Number of lines in the buffer.
   */
  int get_line_count() const;
  
  /** Gets the number of characters in the buffer; note that characters
   * and bytes are not the same, you can't e.g.\ expect the contents of
   * the buffer in string form to be this many bytes long. The character
   * count is cached, so this function is very fast.
   * @return Number of characters in the buffer.
   */
  int get_char_count() const;
  int size() const;

  
  /** Get the Gtk::TextTagTable associated with this buffer.
   * @return The buffer's tag table.
   */
  Glib::RefPtr<TextBuffer::TagTable> get_tag_table();
  
  /** Get the Gtk::TextTagTable associated with this buffer.
   * @return The buffer's tag table.
   */
  Glib::RefPtr<const TextBuffer::TagTable> get_tag_table() const;

  void set_text(const Glib::ustring& text);
  void set_text(const char* text_begin, const char* text_end);

  /** Alias for set_text(). */
  void assign(const Glib::ustring& text);
  /** Alias for set_text(). */
  void assign(const char* text_begin, const char* text_end);

  iterator insert(const iterator& pos, const Glib::ustring& text);
  iterator insert(const iterator& pos, const char* text_begin, const char* text_end);

  void insert_at_cursor(const Glib::ustring& text);
  void insert_at_cursor(const char* text_begin, const char* text_end);

  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const Glib::ustring& text, bool default_editable = true);

  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const char* text_begin, const char* text_end, bool default_editable = true);

  bool insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable = true);
  bool insert_interactive_at_cursor(const char* text_begin, const char* text_end,
                                    bool default_editable = true);

  iterator insert(const iterator& pos, const iterator& range_begin, const iterator& range_end);
  

  std::pair<iterator,bool> insert_interactive(const iterator& pos, const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::RefPtr<Tag>& tag);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::RefPtr<Tag>& tag);

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::ustring& tag_name);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::ustring& tag_name);

  iterator insert_with_tags(const iterator& pos, const Glib::ustring& text,
                            const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags);
  iterator insert_with_tags(const iterator& pos, const char* text_begin, const char* text_end,
                            const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags);

  iterator insert_with_tags_by_name(const iterator& pos, const Glib::ustring& text,
                                    const Glib::StringArrayHandle& tag_names);
  iterator insert_with_tags_by_name(const iterator& pos, const char* text_begin, const char* text_end,
                                    const Glib::StringArrayHandle& tag_names);

  ///Returns the iterator where the deletion occured.
  iterator erase(const iterator& range_begin, const iterator& range_end);
  

  ///Returns the iterator where the deletion occured or end() if no text was deleted.
  std::pair<iterator,bool> erase_interactive(const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  /** Returns the text in the range [ @a start , @a end ). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   *  @a include_hidden_chars  is <tt>false</tt>. Does not include characters
   * representing embedded images, so byte and character indexes into
   * the returned string do <em>not</em> correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_slice().
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_text(const iterator& range_begin, const iterator& range_end, bool include_hidden_chars = true);
  Glib::ustring get_text(bool include_hidden_chars = true);

  
  /** Returns the text in the range [ @a start , @a end ). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   *  @a include_hidden_chars  is <tt>false</tt>. The returned string includes a
   * 0xFFFC character whenever the buffer contains
   * embedded images, so byte and character indexes into
   * the returned string <em>do</em> correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_text(). Note that 0xFFFC can occur in normal
   * text as well, so it is not a reliable indicator that a pixbuf or
   * widget is in the buffer.
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_slice(const iterator& range_begin, const iterator& range_end, bool include_hidden_chars = true);

  iterator insert_pixbuf(const iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

  iterator insert_child_anchor(const iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  

  Glib::RefPtr<TextChildAnchor> create_child_anchor(const iterator& pos);
  

  /** Creates a mark at position @a where . If @a mark_name  is <tt>0</tt>, the mark
   * is anonymous; otherwise, the mark can be retrieved by name using
   * get_mark(). If a mark has left gravity, and text is
   * inserted at the mark's current location, the mark will be moved to
   * the left of the newly-inserted text. If the mark has right gravity
   * ( @a left_gravity  = <tt>false</tt>), the mark will end up on the right of
   * newly-inserted text. The standard left-to-right cursor is a mark
   * with right gravity (when you type, the cursor stays on the right
   * side of the text you're typing).
   * 
   * The caller of this function does <em>not</em> own a reference
   * to the returned Gtk::TextMark, so you can ignore the return value
   * if you like. Marks are owned by the buffer and go away when the
   * buffer does.
   * 
   * Emits the "mark_set" signal as notification of the mark's initial
   * placement.
   * @param mark_name Name for mark, or <tt>0</tt>.
   * @param where Location to place mark.
   * @param left_gravity Whether the mark has left gravity.
   * @return The new Gtk::TextMark object.
   */
  Glib::RefPtr<TextBuffer::Mark> create_mark(const Glib::ustring& mark_name, const iterator& where, bool left_gravity = true);

  /** Create an anonymous mark. */
  Glib::RefPtr<Mark> create_mark(const iterator& where, bool left_gravity = true);

  
  /** Moves @a mark  to the new location @a where . Emits the "mark_set" signal
   * as notification of the move.
   * @param mark A Gtk::TextMark.
   * @param where New location for @a mark  in @a buffer .
   */
  void move_mark(const Glib::RefPtr<Mark>& mark, const iterator& where);
  
  /** Deletes @a mark , so that it's no longer located anywhere in the
   * buffer. Removes the reference the buffer holds to the mark, so if
   * you don't keep a Glib::RefPtr to the mark, it will be freed. Even
   * if the mark isn't freed, most operations on @a mark  become
   * invalid. There is no way to undelete a
   * mark. Gtk::TextMark::get_deleted() will return <tt>true</tt> after this
   * function has been called on a mark; Gtk::TextMark::get_deleted()
   * indicates that a mark no longer belongs to a buffer. The "mark_deleted"
   * signal will be emitted as notification after the mark is deleted.
   * @param mark A Gtk::TextMark in @a buffer .
   */
  void delete_mark(const Glib::RefPtr<Mark>& mark);
  
  /** Returns the mark named @a name  in buffer @a buffer , or <tt>0</tt> if no such
   * mark exists in the buffer.
   * @param name A mark name.
   * @return A Gtk::TextMark, or <tt>0</tt>.
   */
  Glib::RefPtr<TextBuffer::Mark> get_mark(const Glib::ustring& name);
  
  /** Returns the mark named @a name  in buffer @a buffer , or <tt>0</tt> if no such
   * mark exists in the buffer.
   * @param name A mark name.
   * @return A Gtk::TextMark, or <tt>0</tt>.
   */
  Glib::RefPtr<const TextBuffer::Mark> get_mark(const Glib::ustring& name) const;

  
  /** Moves the mark named @a name  (which must exist) to location @a where .
   * See move_mark() for details.
   * @param name Name of a mark.
   * @param where New location for mark.
   */
  void move_mark_by_name(const Glib::ustring& name, const iterator& where);
  
  /** Deletes the mark named @a name ; the mark must exist. See
   * delete_mark() for details.
   * @param name Name of a mark in @a buffer .
   */
  void delete_mark_by_name(const Glib::ustring& name);

  
  /** Returns the mark that represents the cursor (insertion point).
   * Equivalent to calling get_mark() to get the mark
   * named "insert", but very slightly more efficient, and involves less
   * typing.
   * @return Insertion point mark.
   */
  Glib::RefPtr<TextBuffer::Mark> get_insert();
  
  /** Returns the mark that represents the selection bound.  Equivalent
   * to calling get_mark() to get the mark named
   * "selection_bound", but very slightly more efficient, and involves
   * less typing.
   * 
   * The currently-selected text in @a buffer  is the region between the
   * "selection_bound" and "insert" marks. If "selection_bound" and
   * "insert" are in the same place, then there is no current selection.
   * get_selection_bounds() is another convenient function
   * for handling the selection, if you just want to know whether there's a
   * selection and what its bounds are.
   * @return Selection bound mark.
   */
  Glib::RefPtr<TextBuffer::Mark> get_selection_bound();

  
  /** This function moves the "insert" and "selection_bound" marks
   * simultaneously.  If you move them to the same place in two steps
   * with move_mark(), you will temporarily select a
   * region in between their old and new locations, which can be pretty
   * inefficient since the temporarily-selected region will force stuff
   * to be recalculated. This function moves them as a unit, which can
   * be optimized.
   * @param where Where to put the cursor.
   */
  void place_cursor(const iterator& where);
  
  /** Emits the "apply_tag" signal on @a buffer . The default
   * handler for the signal applies @a tag  to the given range.
   *  @a start  and @a end  do not have to be in order.
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag(const Glib::RefPtr<Tag>& tag, const iterator& range_begin, const iterator& range_end);
  
  /** Emits the "remove_tag" signal. The default handler for the signal
   * removes all occurrences of @a tag  from the given range. @a start  and
   *  @a end  don't have to be in order.
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag(const Glib::RefPtr<Tag>& tag, const iterator& range_begin, const iterator& range_end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer's tag table to
   * get a Gtk::TextTag, then calls apply_tag().
   * @param name Name of a named Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag_by_name(const Glib::ustring& name, const iterator& range_begin, const iterator& range_end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer's tag table to
   * get a Gtk::TextTag, then calls remove_tag().
   * @param name Name of a Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag_by_name(const Glib::ustring& name, const iterator& range_begin, const iterator& range_end);
  
  /** Removes all tags in the range between @a start  and @a end .  Be careful
   * with this function; it could remove tags added in code unrelated to
   * the code you're currently writing. That is, using this function is
   * probably a bad idea if you have two or more unrelated code sections
   * that add tags.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_all_tags(const iterator& range_begin, const iterator& range_end);

  Glib::RefPtr<Tag> create_tag(const Glib::ustring& tag_name);

  iterator get_iter_at_line_offset(int line_number, int char_offset);
  iterator get_iter_at_line_index(int line_number, int byte_index);
  iterator get_iter_at_offset(int char_offset);
  iterator get_iter_at_line(int line_number);
  iterator begin();
  iterator end();
  void get_bounds(iterator& range_begin, iterator& range_end);

  iterator get_iter_at_mark(const Glib::RefPtr<Mark>& mark);
  iterator get_iter_at_child_anchor(const Glib::RefPtr<TextChildAnchor>& anchor);

  
  /** Indicates whether the buffer has been modified since the last call
   * to set_modified() set the modification flag to
   * <tt>false</tt>. Used for example to enable a "save" function in a text
   * editor.
   * @return <tt>true</tt> if the buffer has been modified.
   */
  bool get_modified() const;
  
  /** Used to keep track of whether the buffer has been modified since the
   * last time it was saved. Whenever the buffer is saved to disk, call
   * gtk_text_buffer_set_modified ( @a buffer , <tt>false</tt>). When the buffer is modified,
   * it will automatically toggled on the modified bit again. When the modified
   * bit flips, the buffer emits a "modified_changed" signal.
   * @param setting Modification flag setting.
   */
  void set_modified(bool setting = true);

  //TODO_API: Use Glib::RefPtr<Clipboard>
  
  /** Adds @a clipboard  to the list of clipboards in which the selection contents
   * of @a buffer  are available. In most cases, @a clipboard  will be the Gtk::Clipboard
   * of type Gdk::SELECTION_PRIMARY for a view of @a buffer .
   * @param clipboard A Gtk::Clipboard.
   */
  void add_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  /** Removes a Gtk::Clipboard added with add_selection_clipboard()
   * @param clipboard A Gtk::Clipboard added to @a buffer  by add_selection_clipboard().
   */
  void remove_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  /** Copies the currently-selected text to a clipboard, then deletes
   * said text if it's editable.
   * @param clipboard The Gtk::Clipboard object to cut to.
   * @param default_editable Default editability of the buffer.
   */
  void cut_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable = true);
  
  /** Copies the currently-selected text to a clipboard.
   * @param clipboard The Gtk::Clipboard object to copy to.
   */
  void copy_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, const iterator& override_location, bool default_editable = true);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable = true);
  

  void get_selection_bounds(iterator& range_begin, iterator& range_end);
  

  /** Deletes the range between the "insert" and "selection_bound" marks,
   * that is, the currently-selected text. If @a interactive  is <tt>true</tt>,
   * the editability of the selection will be considered (users can't delete
   * uneditable text).
   * @param interactive Whether the deletion is caused by user interaction.
   * @param default_editable Whether the buffer is editable by default.
   * @return Whether there was a non-empty selection to delete.
   */
  bool erase_selection(bool interactive = true, bool default_editable = true);

/* Called to specify atomic user actions, used to implement undo */
  
  /** Called to indicate that the buffer operations between here and a
   * call to end_user_action() are part of a single
   * user-visible operation. The operations between
   * begin_user_action() and
   * end_user_action() can then be grouped when creating
   * an undo stack. Gtk::TextBuffer maintains a count of calls to
   * begin_user_action() that have not been closed with
   * a call to end_user_action(), and emits the "begin_user_action"
   * and "end_user_action" signals only for the outermost pair of calls.
   * This allows you to build user actions from other user actions.
   * 
   * The "interactive" buffer mutation functions, such as
   * insert_interactive(), automatically call begin/end
   * user action around the buffer operations they perform, so there's
   * no need to add extra calls if you user action consists solely of a
   * single call to one of those functions.
   */
  void begin_user_action();
  
  /** Should be paired with a call to begin_user_action().
   * See that function for a full explanation.
   */
  void end_user_action();


  /**
   * @par Prototype:
   * <tt>void %insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)</tt>
   */
  Glib::SignalProxy3<void,const TextBuffer::iterator&,const Glib::ustring&,int> signal_insert();

  
  /**
   * @par Prototype:
   * <tt>void %insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>&> signal_insert_pixbuf();

  
  /**
   * @par Prototype:
   * <tt>void %insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextChildAnchor>&> signal_insert_child_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %erase(const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_erase();

  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void %modified_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_modified_changed();

  
  /**
   * @par Prototype:
   * <tt>void %mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>&> signal_mark_set();

  
  /**
   * @par Prototype:
   * <tt>void %mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   */
  Glib::SignalProxy1<void,const Glib::RefPtr<TextBuffer::Mark>&> signal_mark_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_apply_tag();

  
  /**
   * @par Prototype:
   * <tt>void %remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_remove_tag();

  
  /**
   * @par Prototype:
   * <tt>void %begin_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_begin_user_action();

  
  /**
   * @par Prototype:
   * <tt>void %end_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_end_user_action();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes);
  virtual void on_insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  virtual void on_insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  virtual void on_erase(const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_changed();
  virtual void on_modified_changed();
  virtual void on_mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark);
  virtual void on_mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark);
  virtual void on_apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_begin_user_action();
  virtual void on_end_user_action();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TextBuffer */
  Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTBUFFER_H */

