// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_MODULE_H
#define _GLIBMM_MODULE_H


/* $Id: module.hg,v 1.3 2002/06/19 17:04:05 daniel Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmmconfig.h>
#include <string>

GTKMM_USING_STD(string)

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GModule GModule; }
#endif


namespace Glib
{

/** @addtogroup glibmmEnums Enums and Flags */

/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%ModuleFlags operator|(ModuleFlags, ModuleFlags)</tt><br>
 * <tt>%ModuleFlags operator&(ModuleFlags, ModuleFlags)</tt><br>
 * <tt>%ModuleFlags operator^(ModuleFlags, ModuleFlags)</tt><br>
 * <tt>%ModuleFlags operator~(ModuleFlags)</tt><br>
 * <tt>%ModuleFlags& operator|=(ModuleFlags&, ModuleFlags)</tt><br>
 * <tt>%ModuleFlags& operator&=(ModuleFlags&, ModuleFlags)</tt><br>
 * <tt>%ModuleFlags& operator^=(ModuleFlags&, ModuleFlags)</tt><br>
 */
enum ModuleFlags
{
  MODULE_BIND_LAZY = 1 << 0,
  MODULE_BIND_MASK = 0x01
};

/** @ingroup glibmmEnums */
inline ModuleFlags operator|(ModuleFlags lhs, ModuleFlags rhs)
  { return static_cast<ModuleFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline ModuleFlags operator&(ModuleFlags lhs, ModuleFlags rhs)
  { return static_cast<ModuleFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline ModuleFlags operator^(ModuleFlags lhs, ModuleFlags rhs)
  { return static_cast<ModuleFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline ModuleFlags operator~(ModuleFlags flags)
  { return static_cast<ModuleFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline ModuleFlags& operator|=(ModuleFlags& lhs, ModuleFlags rhs)
  { return (lhs = static_cast<ModuleFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline ModuleFlags& operator&=(ModuleFlags& lhs, ModuleFlags rhs)
  { return (lhs = static_cast<ModuleFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline ModuleFlags& operator^=(ModuleFlags& lhs, ModuleFlags rhs)
  { return (lhs = static_cast<ModuleFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


//TODO: Replace get_last_error() with exceptions?
//Provide operator()?
class Module
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Module CppObjectType;
  typedef GModule BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  explicit Module(const std::string& file_name, ModuleFlags flags = ModuleFlags(0));
  virtual ~Module();

  
  static bool get_supported();
  
  void make_resident();
  
  static std::string get_last_error();
  
  bool get_symbol(const std::string& symbol_name, void*& symbol) const;
  
  std::string get_name() const;
  
  static std::string build_path(const std::string& directory, const std::string& module_name);

  GModule*       gobj()       { return gobject_; }
  const GModule* gobj() const { return gobject_; }

protected:
  GModule* gobject_;

private:
  // noncopyable
  Module(const Module&);
  Module& operator=(const Module&);


};

} // namespace Glib


#endif /* _GLIBMM_MODULE_H */

