# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
import gobject

class _Nothing:
    pass

class WidgetRegistry:
    def __init__(self):
        self._widget_types = {}
        
    def add(self, type_name, widget_class):
        self._widget_types[type_name] = widget_class
        
    def get_by_name(self, type_name, default=_Nothing):
        if default is not _Nothing and not self.has_name(type_name):
            return
        
        return self._widget_types.get(type_name, None)

    def has_name(self, type_name):
        return self._widget_types.has_key(type_name)
        
    def get_by_type(self, gtype, default=_Nothing):
        type_name = gobject.type_name(gtype)
        return self.get_by_name(type_name, default)

    def clean(self):
        self._widget_types = {}

widget_registry = WidgetRegistry()
