# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
import optparse

import gtk

from gazpacho import application, gladegtk
from gazpacho.widgetregistry import widget_registry
from gazpacho.l10n import _

from os import remove, rmdir
from os.path import isdir, isfile

def dump_param_specs(widget_name):
    wc = widget_registry.get_by_name(widget_name)
    wc.dump_param_specs()

def dump_properties(widget_name):
    wc = widget_registry.get_by_name(widget_name)
    wc.dump_properties()

def launch(filename=None):
    gazpacho = application.Application()
    gladegtk.init_gladegtk(gazpacho)

    # Show ProjectWindow first, so we can get
    # the windows from the loaded files on top of it
    gazpacho.show_all()

    if filename:
        gazpacho.open_project(filename)
    else:
        gazpacho.new_project()

    gtk.main()

def uninstall():
    """This function removes all the files installed by Gazpacho.
    It takes the file list from files.py, which is created at install time.
    This should be used in Linux only. In Windows use the standard uninstall
    software procedure.
    """
    print _("This will remove Gazpacho and all its files from your hard drive")
    response = raw_input(_("Are you sure do you want to continue? [%s|No] ") %\
                         _("yes"))

    if response != _("yes"):
        return

    print _('Uninstalling Gazpacho'),
    from files import files
    for file in files:
        if isfile(file):
            remove(file)
        elif isdir(file):
            rmdir(file)
        else:
            print _('I do not know how to remove %s' % file)

def main(args=[]):
    parser = optparse.OptionParser()
    parser.add_option('', '--dump',
                      action="store", type="string",
                      dest="dump_param_specs",
                      help=_("Dump widget param specs"))
    parser.add_option('', '--debug',
                      action="store_true", 
                      dest="debug",
                      help=_("Turn on pdb debugging support"))
    parser.add_option('', '--props',
                      action="store", type="string",
                      dest="dump_properties",
                      help=_("Dump widget properties"))
    parser.add_option('', '--uninstall',
                      action="store_true",
                      dest="uninstall",
                      help=_("Uninstall Gazpacho from your hard drive"))
    
    options, args = parser.parse_args(args)

    if options.uninstall:
        uninstall()
        return
    
    if options.dump_param_specs:
        dump_param_specs(options.dump_param_specs)
        return
    elif options.dump_properties:
        dump_properties(options.dump_properties)
        return

    filename = None
    if len(args) >= 2:
        filename = args[1]
        
    if options.debug:
        import pdb
        pdb.run('launch(filename)', globals(), locals())
    else:
        launch(filename)
