import unittest
from os.path import join
from utils import refresh_gui, currentdir

import gtk

from gazpacho.loader.proxy import Proxy

msg = 'Somebody put something in my drink'

class MyProxy(Proxy):
    def __init__(self):
        Proxy.__init__(self, gladefile=join(currentdir, 'simple_window.glade'))

    def on_button1__clicked(self, button):
        self.label1.set_text(msg)

class ProxyTest(unittest.TestCase):
    def testConnect(self):
        mp = MyProxy()
        self.assertEqual(isinstance(mp.window1, gtk.Window), True)
        self.assertEqual(isinstance(mp.label1, gtk.Label), True)
        self.assertEqual(isinstance(mp.button1, gtk.Button), True)

        refresh_gui()
        mp.button1.clicked()
        refresh_gui()
        self.assertEqual(mp.label1.get_text(), msg)
        
if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(ProxyTest))
    unittest.TextTestRunner(verbosity=2).run(suite)
