#!/usr/bin/env python

from glob import glob
import os
from os.path import join
import sys
from shutil import copyfile
from distutils.core import setup

from langadmin import LangAdmin

def write_installed_files(files_to_remove):
    f = file(join('gazpacho', 'files.py'), 'w')
    files = ["'%s'" % filename for filename in files_to_remove]
    f.write('files = [%s]\n' % ',\n'.join(files))
    f.close()

installed_files = []

data_files = []

# In Win32 we can't call our script 'gazpacho' since all the files must have
# an extension if we just want to double click on them to run the program.
# We can't neither call it gazpacho.py because we have already a package called
# gazpacho in site-packages and doing so would make us run recursive imports
if sys.platform == 'win32':
    copyfile(join('bin', 'gazpacho'), join('bin', 'launch-gazpacho.py'))
    copyfile(join('bin', 'gazpacho'), join('bin', 'launch-gazpacho.pyw'))
    scripts = ['bin/launch-gazpacho.py', 'bin/launch-gazpacho.pyw',
               'bin/create_path_on_win32.py']
    prefix = ""
else:
    prefix = sys.prefix
    i = 0
    for arg in sys.argv:
        if arg.startswith('--prefix='):
            prefix = arg.split('=', 1)[1]
            break
        elif arg == '--prefix' and len(sys.argv) > i:
            prefix = sys.argv[i+1]
            break
        i += 1

    f = file(join('gazpacho', 'path.py'), 'w')
    f.write('pixmaps_dir = r"%s"\n' % join(prefix, 'share', 'gazpacho', 'pixmaps'))
    f.write('languages_dir = r"%s"\n' % join(prefix, 'share', 'locale'))
    f.write('catalogs_dir = r"%s"\n' % join(prefix, 'share', 'gazpacho', 'catalogs'))
    f.close()
    
    scripts = ['bin/gazpacho']
    installed_files.append(join(prefix, scripts[0]))

    data_files.append((join('share', 'applications'), ('gazpacho.desktop',)))
    installed_files.append(join(prefix, 'share', 'applications',
                                'gazpacho.desktop'))

data_files += [('share/gazpacho/pixmaps', glob(join('pixmaps', '*.png'))),
	      ('share/gazpacho/catalogs', glob(join('catalogs', '*.xml')))]

installed_files += [join(prefix, 'share', 'gazpacho', f) for f \
                    in glob(join('pixmaps', '*.png'))]
installed_files.append(join(prefix, 'share', 'gazpacho', 'pixmaps'))
installed_files += [join(prefix, 'share', 'gazpacho', f) for f \
                    in glob(join('catalogs', '*.xml'))]
installed_files.append(join(prefix, 'share', 'gazpacho', 'catalogs'))
installed_files.append(join(prefix, 'share', 'gazpacho'))

# Now for the languages files
langadmin = LangAdmin(po_dir='po', pot_file='gazpacho.pot',
                      mo_file='gazpacho.mo', lang_dir='locale')
langadmin.generate_mo_files()
for lang in os.listdir('locale'):
    filename = join('locale', lang, 'LC_MESSAGES', 'gazpacho.mo')
    data_files.append((join('share', 'locale', lang, 'LC_MESSAGES'), (filename,)))
    installed_files.append(join(prefix, 'share', filename))

# add the python files to the list of files to uninstall
pythondir = 'python%d.%d' % (sys.version_info[0], sys.version_info[1])
packages_dir = join(prefix, 'lib', pythondir, 'site-packages')
loader_py_files = [join(packages_dir, f) for f \
                   in glob(join('gazpacho', 'loader', '*.py'))]
loader_pyc_files = [f+'c' for f in loader_py_files]
installed_files += loader_py_files + loader_pyc_files
installed_files.append(join(packages_dir, 'gazpacho', 'loader'))
gazp_py_files = [join(packages_dir, f) for f in glob(join('gazpacho', '*.py'))]
gazp_pyc_files = [f+'c' for f in gazp_py_files]
installed_files += gazp_py_files + gazp_pyc_files
installed_files.append(join(packages_dir, 'gazpacho'))

# save the installed files list for the uninstall script
write_installed_files(installed_files)

setup(name='Gazpacho',
      version='0.5.0',
      description='GTK+ GUI Designer',
      author='SICEm S.L.',
      author_email='lgs@sicem.biz',
      url='http://gruppy.sicem.biz',
      license='LGPL',
      packages=['gazpacho', 'gazpacho.loader'],
      scripts=scripts,
      data_files=data_files
      )
