// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/path.h>
#include <cluttermm/private/path_p.h>

/*
 * Copyright (c) 2008  The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cstring>

#include <clutter/clutter.h>

namespace
{

// Lookup table to map from ClutterPathNodeType to the number of points used
static const unsigned char n_points[4] =
{
  2, // CLUTTER_PATH_MOVE_TO
  2, // CLUTTER_PATH_LINE_TO
  3, // CLUTTER_PATH_CURVE_TO
  0  // CLUTTER_PATH_CLOSE
};

} // anonymous namespace

namespace Clutter
{

PathNode::PathNode(PathNodeType type)
{
  gobject_.type = static_cast<ClutterPathNodeType>(int(type));
  std::memset(&gobject_.points, 0, sizeof(gobject_.points));
}

PathNode::size_type PathNode::size() const
{
  return n_points[gobject_.type % G_N_ELEMENTS(n_points)];
}

bool PathNode::empty() const
{
  return (gobject_.type == CLUTTER_PATH_CLOSE);
}

PathNode::iterator PathNode::begin()
{
  return reinterpret_cast<Knot*>(&gobject_.points[0]);
}

PathNode::iterator PathNode::end()
{
  const size_type count = n_points[gobject_.type % G_N_ELEMENTS(n_points)];
  return reinterpret_cast<Knot*>(&gobject_.points[count]);
}

PathNode::const_iterator PathNode::begin() const
{
  return reinterpret_cast<const Knot*>(&gobject_.points[0]);
}

PathNode::const_iterator PathNode::end() const
{
  const size_type count = n_points[gobject_.type % G_N_ELEMENTS(n_points)];
  return reinterpret_cast<const Knot*>(&gobject_.points[count]);
}

Path::Nodes::size_type Path::Nodes::size() const
{
  return clutter_path_get_n_nodes(path_);
}

Path::Nodes::const_reference Path::Nodes::operator[](size_type i) const
{
  PathNode node (PATH_CLOSE);
  clutter_path_get_node(path_, i, node.gobj());
  return node;
}

Path::Nodes::reference::operator PathNode() const
{
  PathNode node (PATH_CLOSE);
  clutter_path_get_node(path_, index_, node.gobj());
  return node;
}

Path::Nodes::reference& Path::Nodes::reference::operator=(const PathNode& node)
{
  clutter_path_replace_node(path_, index_, node.gobj());
  return *this;
}

Path::Nodes::const_iterator::reference Path::Nodes::const_iterator::operator*() const
{
  PathNode node (PATH_CLOSE);
  clutter_path_get_node(ref_.path_, ref_.index_, node.gobj());
  return node;
}

Path::Nodes::const_iterator::reference Path::Nodes::const_iterator::operator[](difference_type i) const
{
  PathNode node (PATH_CLOSE);
  clutter_path_get_node(ref_.path_, ref_.index_ + i, node.gobj());
  return node;
}

namespace {

static void c_foreach_callback(const ClutterPathNode *node,  gpointer data)
{
  Clutter::Path::ForEachSlot* slot = static_cast<Clutter::Path::ForEachSlot*>(data);
  if(slot)
    (*slot)(Clutter::PathNode(node));
}

} //anonymous namespace

void Path::foreach(const ForEachSlot& slot)
{
  const void* data = &slot;
  clutter_path_foreach(gobj(), &c_foreach_callback, const_cast<void*>(data));
}

} // namespace Clutter

namespace
{
} // anonymous namespace


namespace Glib
{

Clutter::PathNode& wrap(ClutterPathNode* object)
{
  return *reinterpret_cast<Clutter::PathNode*>(object);
}

const Clutter::PathNode& wrap(const ClutterPathNode* object)
{
  return *reinterpret_cast<const Clutter::PathNode*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType PathNode::get_type()
{
  return clutter_path_node_get_type();
}

PathNode::PathNode()
{
  GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterPathNode);
}

PathNode::PathNode(const ClutterPathNode* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterPathNode);
}


bool operator==(const PathNode& lhs, const PathNode& rhs)
{
  return (clutter_path_node_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const PathNode& lhs, const PathNode& rhs)
{
  return (clutter_path_node_equal(lhs.gobj(), rhs.gobj()) == 0);
}


} // namespace Clutter


namespace Glib
{

Glib::RefPtr<Clutter::Path> wrap(ClutterPath* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Path>( dynamic_cast<Clutter::Path*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Path_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Path_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_path_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Path_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Path_Class::wrap_new(GObject* object)
{
  return new Path((ClutterPath*)object);
}


/* The implementation: */

ClutterPath* Path::gobj_copy()
{
  reference();
  return gobj();
}

Path::Path(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{
   if(gobject_ && g_object_is_floating (gobject_))
     g_object_ref_sink(gobject_); //Stops it from being floating.

}

Path::Path(ClutterPath* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Path::~Path()
{}


Path::CppClassType Path::path_class_; // initialize static member

GType Path::get_type()
{
  return path_class_.init().get_type();
}


GType Path::get_base_type()
{
  return clutter_path_get_type();
}

Path::Path()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(path_class_.init()))
{
  
   if(gobject_ && g_object_is_floating (gobject_))
     g_object_ref_sink(gobject_); //Stops it from being floating.

}

Path::Path(const Glib::ustring& description)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(path_class_.init(), "description", description.c_str(), static_cast<char*>(0)))
{
  
   if(gobject_ && g_object_is_floating (gobject_))
     g_object_ref_sink(gobject_); //Stops it from being floating.

}

Glib::RefPtr<Path> Path::create()
{
  return Glib::RefPtr<Path>( new Path() );
}
Glib::RefPtr<Path> Path::create(const Glib::ustring& description)
{
  return Glib::RefPtr<Path>( new Path(description) );
}
void Path::add_move_to(int x, int y)
{
clutter_path_add_move_to(gobj(), x, y); 
}

void Path::add_rel_move_to(int x, int y)
{
clutter_path_add_rel_move_to(gobj(), x, y); 
}

void Path::add_line_to(int x, int y)
{
clutter_path_add_line_to(gobj(), x, y); 
}

void Path::add_rel_line_to(int x, int y)
{
clutter_path_add_rel_line_to(gobj(), x, y); 
}

void Path::add_curve_to(int x1, int y1, int x2, int y2, int x3, int y3)
{
clutter_path_add_curve_to(gobj(), x1, y1, x2, y2, x3, y3); 
}

void Path::add_rel_curve_to(int x1, int y1, int x2, int y2, int x3, int y3)
{
clutter_path_add_rel_curve_to(gobj(), x1, y1, x2, y2, x3, y3); 
}

void Path::add_close()
{
clutter_path_add_close(gobj()); 
}

bool Path::add_string(const Glib::ustring& str)
{
  return clutter_path_add_string(gobj(), str.c_str());
}

Glib::ustring Path::get_description() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(clutter_path_get_description(const_cast<ClutterPath*>(gobj())));
}

void Path::set_description(const Glib::ustring& str)
{
clutter_path_set_description(gobj(), str.c_str()); 
}

void Path::add_cairo_path(const Glib::RefPtr<Cairo::Path>& path)
{
clutter_path_add_cairo_path(gobj(), (path)->cobj()); 
}

void Path::to_cairo_path(Glib::RefPtr<Cairo::Context>& context) const
{
clutter_path_to_cairo_path(const_cast<ClutterPath*>(gobj()), (context)->cobj()); 
}

void Path::clear()
{
clutter_path_clear(gobj()); 
}

guint Path::get_position(double progress, Knot& position)
{
  return clutter_path_get_position(gobj(), progress, (position).gobj());
}

guint Path::get_length() const
{
  return clutter_path_get_length(const_cast<ClutterPath*>(gobj()));
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Path::property_description() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "description");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Path::property_description() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "description");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Path::property_length() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "length");
}
#endif //GLIBMM_PROPERTIES_ENABLED


} // namespace Clutter


