// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BIN_LAYOUT_H
#define _CLUTTERMM_BIN_LAYOUT_H


#include <glibmm.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/layout-manager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBinLayout ClutterBinLayout;
typedef struct _ClutterBinLayoutClass ClutterBinLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BinLayout_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum BinAlignment
{
  BIN_ALIGNMENT_FIXED,
  BIN_ALIGNMENT_FILL,
  BIN_ALIGNMENT_START,
  BIN_ALIGNMENT_END,
  BIN_ALIGNMENT_CENTER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::BinAlignment> : public Glib::Value_Enum<Clutter::BinAlignment>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class BinLayout :
    public LayoutManager
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BinLayout CppObjectType;
  typedef BinLayout_Class CppClassType;
  typedef ClutterBinLayout BaseObjectType;
  typedef ClutterBinLayoutClass BaseClassType;

private:  friend class BinLayout_Class;
  static CppClassType binlayout_class_;

private:
  // noncopyable
  BinLayout(const BinLayout&);
  BinLayout& operator=(const BinLayout&);

protected:
  explicit BinLayout(const Glib::ConstructParams& construct_params);
  explicit BinLayout(ClutterBinLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BinLayout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBinLayout*       gobj()       { return reinterpret_cast<ClutterBinLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBinLayout* gobj() const { return reinterpret_cast<ClutterBinLayout*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBinLayout* gobj_copy();

private:


protected:
  explicit BinLayout(BinAlignment x_align, BinAlignment y_align);

public:
  
  static Glib::RefPtr<BinLayout> create(BinAlignment x_align, BinAlignment y_align);


  /** Sets the horizontal and vertical alignment policies to be applied
   * to a @a child of @a self
   * 
   * If @a child is <tt>0</tt> then the @a x_align and @a y_align values will
   * be set as the default alignment policies
   * 
   * @newin{1,2}
   * @param child A child of @a container.
   * @param x_align The horizontal alignment policy to be used for the @a child
   * inside @a container.
   * @param y_align The vertical aligment policy to be used on the @a child
   * inside @a container.
   */
  void set_alignment(const Glib::RefPtr<Actor>& child, BinAlignment x_align, BinAlignment y_align);
  
  /** Retrieves the horizontal and vertical alignment policies for
   * a child of @a self
   * 
   * If @a child is <tt>0</tt> the default alignment policies will be returned
   * instead
   * 
   * @newin{1,2}
   * @param child A child of @a container.
   * @param x_align Return location for the horizontal
   * alignment policy.
   * @param y_align Return location for the vertical
   * alignment policy.
   */
  void get_alignment(const Glib::RefPtr<Actor>& child, BinAlignment &x_align, BinAlignment &y_align) const;
  
  /** Adds a Clutter::Actor to the container using @a self and
   * sets the alignment policies for it
   * 
   * This function is equivalent to Clutter::Container::add_actor()
   * and Clutter::LayoutManager::child_set_property() but it does not
   * require a pointer to the Clutter::Container associated to the
   * Clutter::BinLayout
   * 
   * @newin{1,2}
   * @param child A Clutter::Actor.
   * @param x_align Horizontal alignment policy for @a child.
   * @param y_align Vertical alignment policy for @a child.
   */
  void add(const Glib::RefPtr<Actor>& child, BinAlignment x_align, BinAlignment y_align);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Default horizontal alignment for the actors inside the layout manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<BinAlignment> property_x_align() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Default horizontal alignment for the actors inside the layout manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<BinAlignment> property_x_align() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Default vertical alignment for the actors inside the layout manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<BinAlignment> property_y_align() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Default vertical alignment for the actors inside the layout manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<BinAlignment> property_y_align() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BinLayout
   */
  Glib::RefPtr<Clutter::BinLayout> wrap(ClutterBinLayout* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BIN_LAYOUT_H */

