// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_INTERVAL_H
#define _CLUTTERMM_INTERVAL_H


#include <glibmm.h>

/* Copyright (C) 2009 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterInterval ClutterInterval;
typedef struct _ClutterIntervalClass ClutterIntervalClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Interval_Class; } // namespace Clutter
namespace Clutter
{


class Interval : public Glib::Object
{

  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Interval CppObjectType;
  typedef Interval_Class CppClassType;
  typedef ClutterInterval BaseObjectType;
  typedef ClutterIntervalClass BaseClassType;

private:  friend class Interval_Class;
  static CppClassType interval_class_;

private:
  // noncopyable
  Interval(const Interval&);
  Interval& operator=(const Interval&);

protected:
  explicit Interval(const Glib::ConstructParams& construct_params);
  explicit Interval(ClutterInterval* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Interval();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterInterval*       gobj()       { return reinterpret_cast<ClutterInterval*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterInterval* gobj() const { return reinterpret_cast<ClutterInterval*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterInterval* gobj_copy();

private:

  
protected:
  Interval(GType type, const Glib::ValueBase& initial, const Glib::ValueBase& final);

public:

  template <typename ValueType>
  Glib::RefPtr<Interval> static create(const ValueType initial, const ValueType final);
  template <typename ValueType>
  Glib::RefPtr<Interval> static create_with_values(const Glib::Value<ValueType>& initial, const Glib::Value<ValueType>& final);

  
  /** Creates a copy of @a interval.
   * 
   * @newin{1,0}
   * @return The newly created Clutter::Interval.
   */
  Glib::RefPtr<Interval> clone() const;
  
  /** Retrieves the Type of the values inside @a interval.
   * 
   * @newin{1,0}
   * @return The type of the value, or G_TYPE_INVALID.
   */
  GType get_value_type() const;
  
  /** Sets the initial value of @a interval to @a value. The value is copied
   * inside the Clutter::Interval.
   * 
   * @newin{1,0}
   * @param value A Value.
   */
  void set_initial_value(const Glib::ValueBase& value);
  
  /** Retrieves the initial value of @a interval and copies
   * it into @a value.
   * 
   * The passed Value must be initialized to the value held by
   * the Clutter::Interval.
   * 
   * @newin{1,0}
   * @param value A Value.
   */
  void get_initial_value(Glib::ValueBase& value) const;
  
  /** Gets the pointer to the initial value of @a interval
   * 
   * @newin{1,0}
   * @return The initial value of the interval.
   * The value is owned by the Clutter::Interval and it should not be
   * modified or freed.
   */
  GValue* peek_initial_value();
  
  /** Sets the final value of @a interval to @a value. The value is
   * copied inside the Clutter::Interval.
   * 
   * @newin{1,0}
   * @param value A Value.
   */
  void set_final_value(const Glib::ValueBase& value);
  
  /** Retrieves the final value of @a interval and copies
   * it into @a value.
   * 
   * The passed Value must be initialized to the value held by
   * the Clutter::Interval.
   * 
   * @newin{1,0}
   * @param value A Value.
   */
  void get_final_value(Glib::ValueBase& value) const;
  
  /** Gets the pointer to the final value of @a interval
   * 
   * @newin{1,0}
   * @return The final value of the interval.
   * The value is owned by the Clutter::Interval and it should not be
   * modified or freed.
   */
  GValue* peek_final_value();

  void set_interval(const Glib::ValueBase& initial, const Glib::ValueBase& final);
  void get_interval(Glib::ValueBase& initial, Glib::ValueBase& final);

  
  /** Computes the value between the @a interval boundaries given the
   * progress @a factor and puts it into @a value.
   * 
   * @newin{1,0}
   * @param factor The progress factor, between 0 and 1.
   * @param value Return location for an initialized Value.
   * @return <tt>true</tt> if the operation was successful.
   */
  bool compute_value(double factor, Glib::ValueBase& value) const;
  
  /** Validates the initial and final values of @a interval against
   * a ParamSpec.
   * 
   * @newin{1,0}
   * @param pspec A ParamSpec.
   * @return <tt>true</tt> if the Clutter::Interval is valid, <tt>false</tt> otherwise.
   */
  bool validate(GParamSpec *pspec) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of the values in the interval.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<GType> property_value_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <typename ValueType>
Glib::RefPtr<Interval> Interval::create(const ValueType initial, const ValueType final)
{
  Glib::Value<ValueType> initial_val, final_val;
  initial_val.init(Glib::Value<ValueType>::value_type());
  final_val.init(Glib::Value<ValueType>::value_type());
  initial_val.set(initial);
  final_val.set(final);
  return create_with_values(initial_val, final_val);
}

template <typename ValueType>
Glib::RefPtr<Interval> Interval::create_with_values(const Glib::Value<ValueType>& initial, const Glib::Value<ValueType>& final)
{
  return Glib::RefPtr<Interval>( new Interval(initial.value_type(), initial, final) );
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Interval
   */
  Glib::RefPtr<Clutter::Interval> wrap(ClutterInterval* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_INTERVAL_H */

