// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/types.h>
#include <cluttermm/private/types_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>

namespace Clutter
{

Knot::Knot(int x, int y)
{
  ClutterKnot tmp = {x, y};
  gobject_ = clutter_knot_copy(&tmp);
}

void Knot::set_x(int x)
{
  gobject_->x = x;
}

void Knot::set_y(int y)
{
  gobject_->y = y;
}

void Knot::set_xy(int x, int y)
{
  gobject_->x = x;
  gobject_->y = y;
}

Vertex::Vertex(float x, float y, float z)
{
  gobject_.x = x;
  gobject_.y = y;
  gobject_.z = z;
}

Geometry::Geometry(int x, int y, unsigned int width, unsigned int height)
{
  gobject_.x = x;
  gobject_.y = y;
  gobject_.width  = width;
  gobject_.height = height;
}

void Geometry::set_x(int x)
{
  gobject_.x = x;
}

void Geometry::set_y(int y)
{
  gobject_.y = y;
}

void Geometry::set_xy(int x, int y)
{
  gobject_.x = x;
  gobject_.y = y;
}

void Geometry::set_width(unsigned int width)
{
  gobject_.width = width;
}

void Geometry::set_height(unsigned int height)
{
  gobject_.height = height;
}

void Geometry::set_size(unsigned int width, unsigned int height)
{
  gobject_.width  = width;
  gobject_.height = height;
}

} // namespace Clutter

namespace
{
} // anonymous namespace


Clutter::InitError::InitError(Clutter::InitError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (CLUTTER_INIT_ERROR, error_code, error_message)
{}

Clutter::InitError::InitError(GError* gobject)
:
  Glib::Error (gobject)
{}

Clutter::InitError::Code Clutter::InitError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Clutter::InitError::throw_func(GError* gobject)
{
  throw Clutter::InitError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Clutter::InitError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Clutter::InitError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Clutter::InitError::Code>::value_type()
{
  return clutter_init_error_get_type();
}

// static
GType Glib::Value<Clutter::AnimationMode>::value_type()
{
  return clutter_animation_mode_get_type();
}

// static
GType Glib::Value<Clutter::RotateDirection>::value_type()
{
  return clutter_rotate_direction_get_type();
}

// static
GType Glib::Value<Clutter::RotateAxis>::value_type()
{
  return clutter_rotate_axis_get_type();
}

// static
GType Glib::Value<Clutter::Gravity>::value_type()
{
  return clutter_gravity_get_type();
}

// static
GType Glib::Value<Clutter::RequestMode>::value_type()
{
  return clutter_request_mode_get_type();
}

// static
GType Glib::Value<Clutter::FontFlags>::value_type()
{
  return clutter_font_flags_get_type();
}

// static
GType Glib::Value<Clutter::TextDirection>::value_type()
{
  return clutter_text_direction_get_type();
}


namespace Glib
{

Clutter::Knot wrap(ClutterKnot* object, bool take_copy)
{
  return Clutter::Knot(object, take_copy);
}

} // namespace Glib


namespace Clutter
{


// static
GType Knot::get_type()
{
  return clutter_knot_get_type();
}

Knot::Knot()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Knot::Knot(const Knot& other)
:
  gobject_ ((other.gobject_) ? clutter_knot_copy(other.gobject_) : 0)
{}

Knot::Knot(ClutterKnot* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? clutter_knot_copy(gobject) : gobject)
{}

Knot& Knot::operator=(const Knot& other)
{
  Knot temp (other);
  swap(temp);
  return *this;
}

Knot::~Knot()
{
  if(gobject_)
    clutter_knot_free(gobject_);
}

void Knot::swap(Knot& other)
{
  ClutterKnot *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

ClutterKnot* Knot::gobj_copy() const
{
  return clutter_knot_copy(gobject_);
}


 int Knot::get_x() const
{
  return gobj()->x;
}
 
 int Knot::get_y() const
{
  return gobj()->y;
}
 

bool operator==(const Knot& lhs, const Knot& rhs)
{
  return (clutter_knot_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Knot& lhs, const Knot& rhs)
{
  return (clutter_knot_equal(lhs.gobj(), rhs.gobj()) == 0);
}


} // namespace Clutter


namespace Glib
{

Clutter::Vertex& wrap(ClutterVertex* object)
{
  return *reinterpret_cast<Clutter::Vertex*>(object);
}

const Clutter::Vertex& wrap(const ClutterVertex* object)
{
  return *reinterpret_cast<const Clutter::Vertex*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType Vertex::get_type()
{
  return clutter_vertex_get_type();
}

Vertex::Vertex()
{
  GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterVertex);
}

Vertex::Vertex(const ClutterVertex* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterVertex);
}

 float Vertex::get_x() const
{
  return gobj()->x;
}
 
 void Vertex::set_x(const float& value)
{
  gobj()->x = value;
}
 
 float Vertex::get_y() const
{
  return gobj()->y;
}
 
 void Vertex::set_y(const float& value)
{
  gobj()->y = value;
}
 
 float Vertex::get_z() const
{
  return gobj()->z;
}
 
 void Vertex::set_z(const float& value)
{
  gobj()->z = value;
}
 

} // namespace Clutter


namespace Glib
{

Clutter::Geometry& wrap(ClutterGeometry* object)
{
  return *reinterpret_cast<Clutter::Geometry*>(object);
}

const Clutter::Geometry& wrap(const ClutterGeometry* object)
{
  return *reinterpret_cast<const Clutter::Geometry*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType Geometry::get_type()
{
  return clutter_geometry_get_type();
}

Geometry::Geometry()
{
  GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterGeometry);
}

Geometry::Geometry(const ClutterGeometry* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterGeometry);
}

 int Geometry::get_x() const
{
  return gobj()->x;
}
 
 int Geometry::get_y() const
{
  return gobj()->y;
}
 
 unsigned int Geometry::get_width() const
{
  return gobj()->width;
}
 
 unsigned int Geometry::get_height() const
{
  return gobj()->height;
}
 

} // namespace Clutter


