// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_OPACITY_H
#define _CLUTTERMM_BEHAVIOUR_OPACITY_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/behaviour.h>
#include <cluttermm/alpha.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviourOpacity ClutterBehaviourOpacity;
typedef struct _ClutterBehaviourOpacityClass ClutterBehaviourOpacityClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BehaviourOpacity_Class; } // namespace Clutter
namespace Clutter
{


class BehaviourOpacity : public Behaviour
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BehaviourOpacity CppObjectType;
  typedef BehaviourOpacity_Class CppClassType;
  typedef ClutterBehaviourOpacity BaseObjectType;
  typedef ClutterBehaviourOpacityClass BaseClassType;

private:  friend class BehaviourOpacity_Class;
  static CppClassType behaviouropacity_class_;

private:
  // noncopyable
  BehaviourOpacity(const BehaviourOpacity&);
  BehaviourOpacity& operator=(const BehaviourOpacity&);

protected:
  explicit BehaviourOpacity(const Glib::ConstructParams& construct_params);
  explicit BehaviourOpacity(ClutterBehaviourOpacity* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BehaviourOpacity();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviourOpacity*       gobj()       { return reinterpret_cast<ClutterBehaviourOpacity*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviourOpacity* gobj() const { return reinterpret_cast<ClutterBehaviourOpacity*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviourOpacity* gobj_copy();

private:


protected:
  explicit BehaviourOpacity(const Glib::RefPtr<Alpha>& alpha, guint8 opacity_start, guint8 opacity_end);

public:
  
  static Glib::RefPtr<BehaviourOpacity> create(const Glib::RefPtr<Alpha>& alpha, guint8 opacity_start, guint8 opacity_end);


  /** Sets the initial and final levels of the opacity applied by @a behaviour
   * on each actor it controls.
   * 
   * Since: 0.6
   * @param opacity_start Minimum level of opacity.
   * @param opacity_end Maximum level of opacity.
   */
  void set_bounds(guint8 opacity_start, guint8 opacity_end);
  
  /** Gets the initial and final levels of the opacity applied by @a behaviour
   * on each actor it controls.
   * 
   * Since: 0.6
   * @param opacity_start Return location for the minimum level of opacity, or <tt>0</tt>.
   * @param opacity_end Return location for the maximum level of opacity, or <tt>0</tt>.
   */
  void get_bounds(guint8& opacity_start, guint8& opacity_end) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Final opacity level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_opacity_end() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Final opacity level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_opacity_end() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Initial opacity level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_opacity_start() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Initial opacity level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_opacity_start() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BehaviourOpacity
   */
  Glib::RefPtr<Clutter::BehaviourOpacity> wrap(ClutterBehaviourOpacity* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_OPACITY_H */

