// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TEXTURE_H
#define _CLUTTERMM_TEXTURE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/types.h>
#include <clutter/clutter.h> // For CoglHandle
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTexture ClutterTexture;
typedef struct _ClutterTextureClass ClutterTextureClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Texture_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%TextureFlags operator|(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator&(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator^(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator~(TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator|=(TextureFlags&, TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator&=(TextureFlags&, TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator^=(TextureFlags&, TextureFlags)</tt><br>
 */
enum TextureFlags
{
  TEXTURE_RGB_FLAG_BGR = 1 << 1,
  TEXTURE_RGB_FLAG_PREMULT = 1 << 2,
  TEXTURE_YUV_FLAG_YUV2 = 1 << 3
};

/** @ingroup cluttermmEnums */
inline TextureFlags operator|(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator&(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator^(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator~(TextureFlags flags)
  { return static_cast<TextureFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator|=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator&=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator^=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextureFlags> : public Glib::Value_Flags<Clutter::TextureFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum TextureQuality
{
  TEXTURE_QUALITY_LOW,
  TEXTURE_QUALITY_MEDIUM,
  TEXTURE_QUALITY_HIGH
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextureQuality> : public Glib::Value_Enum<Clutter::TextureQuality>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/** Exception class for Clutter::Texture errors.
 */
class TextureError : public Glib::Error
{
public:
  enum Code
  {
    OUT_OF_MEMORY,
    NO_YUV,
    BAD_FORMAT
  };

  TextureError(Code error_code, const Glib::ustring& error_message);
  explicit TextureError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Clutter

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextureError::Code> : public Glib::Value_Enum<Clutter::TextureError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Texture : public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Texture CppObjectType;
  typedef Texture_Class CppClassType;
  typedef ClutterTexture BaseObjectType;
  typedef ClutterTextureClass BaseClassType;

private:  friend class Texture_Class;
  static CppClassType texture_class_;

private:
  // noncopyable
  Texture(const Texture&);
  Texture& operator=(const Texture&);

protected:
  explicit Texture(const Glib::ConstructParams& construct_params);
  explicit Texture(ClutterTexture* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Texture();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTexture*       gobj()       { return reinterpret_cast<ClutterTexture*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTexture* gobj() const { return reinterpret_cast<ClutterTexture*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTexture* gobj_copy();

private:


protected:
  Texture();
  // We do not wrap this constructor because it might throw an error. This
  // gets difficult to get right especially for disabled exceptions in glibmm,
  // and it is easy enough to create a texture and call set_from_file() on
  // it manually.  But we do wrap the create method at least. --danielk
  

  // TODO: Wrap clutter_texture_new_from_actor. This needs changes in clutter
  // since the _new function does a lot more than calling g_object_new().
  //_WRAP_CTOR(Texture(const Glib::RefPtr<Actor>& actor), clutter_texture_new_from_actor)

public:
 

  static Glib::RefPtr<Texture> create();

  static Glib::RefPtr<Texture> create_from_file(const std::string& filename);
  //_WRAP_CREATE(const Glib::RefPtr<Actor>& actor);

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_from_file(const std::string& filename);
#else
  bool set_from_file(const std::string& filename, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_from_rgb_data(const guchar* data, bool has_alpha, int width, int height, int rowstride, int bpp, TextureFlags flags);
#else
  bool set_from_rgb_data(const guchar* data, bool has_alpha, int width, int height, int rowstride, int bpp, TextureFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_from_yuv_data(const guchar* data, int width, int height, TextureFlags flags);
#else
  bool set_from_yuv_data(const guchar* data, int width, int height, TextureFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_area_from_rgb_data(const guchar* data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, TextureFlags flags);
#else
  bool set_area_from_rgb_data(const guchar* data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, TextureFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  void get_base_size(int& width, int& height) const;

  
  TextureQuality get_filter_quality() const;
  
  void set_filter_quality(TextureQuality filter_quality);
  
  int get_amx_tile_waste() const;
  
  void set_max_tile_waste(int max_tile_waste);

  // TODO: Is there a coglmm we could depend on for this?
  
  CoglHandle get_cogl_texture() const;
  
  void set_cogl_texture(CoglHandle handle);
  
  CoglHandle get_cogl_material() const;
  
  void set_cogl_material(CoglHandle handle);

  // TODO: figure out what to do with this GError parameter
  //_WRAP_SIGNAL(void load_finished(GError* error), "load_finished")
  
  /**
   * @par Prototype:
   * <tt>void on_my_%size_change(int width, int height)</tt>
   */

  Glib::SignalProxy2< void,int,int > signal_size_change();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%pixbuf_change()</tt>
   */

  Glib::SignalProxy0< void > signal_pixbuf_change();


 // TODO: What's with the C type?
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The underlying COGL texture handle used to draw this actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<CoglHandle> property_cogl_texture() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The underlying COGL texture handle used to draw this actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<CoglHandle> property_cogl_texture() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Force the underlying texture to be singlularand not made of of smaller space saving inidivual textures.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_disable_slicing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The full path of the file containing the texture.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<std::string> property_filename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Rendering quality used when drawing the texture.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TextureQuality> property_filter_quality() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Rendering quality used when drawing the texture.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TextureQuality> property_filter_quality() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** CoglPixelFormat to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_pixel_format() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Repeat underlying pixbuf rather than scale in x direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_repeat_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Repeat underlying pixbuf rather than scale in x direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_repeat_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Repeat underlying pixbuf rather than scale in y direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_repeat_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Repeat underlying pixbuf rather than scale in y direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_repeat_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Auto sync size of actor to underlying pixbuf dimensions.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_sync_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Auto sync size of actor to underlying pixbuf dimensions.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_sync_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Max wastage dimension of a texture when using sliced textures or -1 to disable slicing. Bigger values use less textures
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_tile_waste() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_size_change(int width, int height);
  virtual void on_pixbuf_change();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Texture
   */
  Glib::RefPtr<Clutter::Texture> wrap(ClutterTexture* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TEXTURE_H */

