// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TIMELINE_H
#define _CLUTTERMM_TIMELINE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTimeline ClutterTimeline;
typedef struct _ClutterTimelineClass ClutterTimelineClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Timeline_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum TimelineDirection
{
  TIMELINE_FORWARD,
  TIMELINE_BACKWARD
};


class Timeline : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Timeline CppObjectType;
  typedef Timeline_Class CppClassType;
  typedef ClutterTimeline BaseObjectType;
  typedef ClutterTimelineClass BaseClassType;

private:  friend class Timeline_Class;
  static CppClassType timeline_class_;

private:
  // noncopyable
  Timeline(const Timeline&);
  Timeline& operator=(const Timeline&);

protected:
  explicit Timeline(const Glib::ConstructParams& construct_params);
  explicit Timeline(ClutterTimeline* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Timeline();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTimeline*       gobj()       { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTimeline* gobj() const { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTimeline* gobj_copy();

private:


protected:
  explicit Timeline(guint num_frames, guint fps);
  explicit Timeline(guint msecs);
public:
  
  static Glib::RefPtr<Timeline> create(guint n_frames, guint fps);

  
  static Glib::RefPtr<Timeline> create(guint msecs);

  
  //We don't wrap this as a copy constructor because there is 
  //no way to use copy constructors with RefPtr:
  
  /** Create a new Clutter::Timeline instance which has property values
   * matching that of supplied timeline. The cloned timeline will not
   * be started and will not be positioned to the current position of
   *  @a timeline: you will have to start it with start().
   * @return A new Clutter::Timeline, cloned from @a timeline
   * 
   * Since 0.4.
   */
  Glib::RefPtr<Timeline> clone() const;

  
  /** Sets the duration of the timeline, in milliseconds. The speed
   * of the timeline depends on the ClutterTimeline:fps setting.
   * 
   * Since: 0.6
   * @param msecs Duration of the timeline in milliseconds.
   */
  void set_duration(guint msecs);
  
  /** Retrieves the duration of a Clutter::Timeline in milliseconds.
   * See set_duration().
   * @return The duration of the timeline, in milliseconds.
   * 
   * Since: 0.6.
   */
  guint get_duration() const;
  
  /** Set the speed in frames per second of the timeline.
   * @param fps New speed of timeline as frames per second.
   */
  void set_speed(guint fps);
  
  /** Gets the frames per second played by @a timeline
   * @return The number of frames per second.
   */
  guint get_speed() const;
  
  /** Starts the Clutter::Timeline playing.
   */
  void start();
  
  /** Pauses the Clutter::Timeline on current frame
   */
  void pause();
  
  /** Stops the Clutter::Timeline and moves to frame 0
   */
  void stop();
  
  /** Rewinds Clutter::Timeline to frame 0.
   */
  void rewind();
  
  /** Sets whether @a timeline should loop.
   * @param loop <tt>true</tt> for enable looping.
   */
  void set_loop(bool loop = true);
  
  /** Gets whether @a timeline is looping
   * @return <tt>true</tt> if the timeline is looping.
   */
  bool get_loop() const;
  
  /** Advance timeline by requested number of frames.
   * @param n_frames Number of frames to skip.
   */
  void skip(guint n_frames);
  
  /** Advance timeline to requested frame number
   * @param frame_num Frame number to advance to.
   */
  void advance(guint frame_num);
  
  /** Request the current frame number of the timeline.
   * @return Current frame number.
   */
  int get_current_frame() const;
  
  /** Retrieves the number of frames and the amount of time elapsed since
   * the last ClutterTimeline::new-frame signal.
   * 
   * This function is only useful inside handlers for the ::new-frame
   * signal, and its behaviour is undefined if the timeline is not
   * playing.
   * @param msecs Return location for the milliseconds elapsed since the last
   * frame, or <tt>0</tt>.
   * @return The amount of frames elapsed since the last one
   * 
   * Since: 0.6.
   */
  guint get_delta(guint& msecs) const;
  
  /** Sets the total number of frames for @a timeline
   * @param n_frames The number of frames.
   */
  void set_n_frames(guint n_frames);
  
  /** Request the total number of frames for the Clutter::Timeline.
   * @return Number of frames for this Clutter::Timeline.
   */
  guint get_n_frames() const;
  
  /** Query state of a Clutter::Timeline instance.
   * @return <tt>true</tt> if timeline is currently playing, <tt>false</tt> if not.
   */
  bool is_playing() const;
  
  /** Sets the delay, in milliseconds, before @a timeline should start.
   * 
   * Since: 0.4
   * @param msecs Delay in milliseconds.
   */
  void set_delay(guint msecs);
  
  /** Retrieves the delay set using set_delay().
   * @return The delay in milliseconds.
   * 
   * Since: 0.4.
   */
  guint get_delay() const;
  
  /** The position of the timeline in a [0, 1] interval.
   * @return The position of the timeline.
   * 
   * Since: 0.6.
   */
  double get_progress() const;
  
  /** Fixed point version of get_progress().
   * @return The position of the timeline as a fixed point value
   * 
   * Since: 0.6.
   */
  Fixed get_progressx() const;
  
  /** Sets the direction of @a timeline, either Clutter::TIMELINE_FORWARD or
   * Clutter::TIMELINE_BACKWARD.
   * 
   * Since: 0.6
   * @param direction The direction of the timeline.
   */
  void set_direction(TimelineDirection direction);
  
  /** Retrieves the direction of the timeline set with
   * set_direction().
   * @return The direction of the timeline
   * 
   * Since: 0.6.
   */
  TimelineDirection get_direction() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_delay() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_delay() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeline frames per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_fps() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeline frames per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_fps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_loop() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_loop() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timelines total number of frames.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_num_frames() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timelines total number of frames.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_num_frames() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%completed()</tt>
   */

  Glib::SignalProxy0< void > signal_completed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%new_frame(gint fram_num)</tt>
   */

  Glib::SignalProxy1< void,gint > signal_new_frame();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paused()</tt>
   */

  Glib::SignalProxy0< void > signal_paused();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%started()</tt>
   */

  Glib::SignalProxy0< void > signal_started();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_completed();
  virtual void on_new_frame(gint fram_num);
  virtual void on_paused();
  virtual void on_started();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Timeline
   */
  Glib::RefPtr<Clutter::Timeline> wrap(ClutterTimeline* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TIMELINE_H */

