/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-glade-signal.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-glade-signal
 * @title: IAnjutaEditorGladeSignal
 * @short_description: Interface for dropping signal handlers
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-goto.h
 * 
 */

#include "ianjuta-editor-glade-signal.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_glade_signal_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-glade-signal-quark");
	}
	
	return quark;
}

static void
ianjuta_editor_glade_signal_base_init (IAnjutaEditorGladeSignalIface* klass)
{
	static gboolean initialized = FALSE;

	
	if (!initialized) {

		/* IAnjutaEditorGladeSignal::drop
		 * @obj: self
		 * @iter: a IAnjutaIterator of the position where drop happens
		 * @signal_data: Signal data in form "widget:signal:handler", e.g.
		 * "GtkToggleButton:toggled:on_toggle_button_toggled"
		 *
		 * Emitted when a signal was received per drag & drop
		 *
		 */
		g_signal_new ("drop",
			IANJUTA_TYPE_EDITOR_GLADE_SIGNAL,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorGladeSignalIface, drop),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__OBJECT_STRING,
			G_TYPE_NONE,
			2,
			G_TYPE_OBJECT,
			G_TYPE_STRING);


		/* IAnjutaEditorGladeSignal::drop-possible
		 * @obj: self
		 * @iter: a IAnjutaIterator of the position where drop would happen
		 *
		 * Emitted when a signal is dragged over the editor
		 *
		 * Return value: TRUE if a signal handler can be dropped, FALSE otherwise
		 */
		g_signal_new ("drop-possible",
			IANJUTA_TYPE_EDITOR_GLADE_SIGNAL,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorGladeSignalIface, drop_possible),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_BOOLEAN__OBJECT,
			G_TYPE_BOOLEAN,
			1,
			G_TYPE_OBJECT);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_glade_signal_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorGladeSignalIface),
			(GBaseInitFunc) ianjuta_editor_glade_signal_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorGladeSignal", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
