// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/application.h>
#include <giomm/private/application_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/file.h>
#include <giomm/actiongroup.h>

namespace Gio
{

void Application::open(const type_vec_files& files, const Glib::ustring& hint)
{
  //TODO: Create a templated helper function for this:
  typedef GFile* cpointer;
  cpointer* files_array = new cpointer[files.size()];
  guint i = 0;
  for(type_vec_files::const_iterator iter = files.begin(); iter != files.end(); iter++)
  {
    type_vec_files::const_reference refPtr = *iter;
    files_array[i] = refPtr->gobj();
  }

  g_application_open(gobj(), files_array, files.size(), hint.c_str());

  delete[] files_array ;
}

} // namespace Gio

namespace
{


static const Glib::SignalProxyInfo Application_signal_startup_info =
{
  "startup",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Application_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Application>( dynamic_cast<Gio::Application*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Application_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Application_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_application_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Application_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->startup = &startup_callback;
  klass->activate = &activate_callback;
}


void Application_Class::startup_callback(GApplication* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_startup();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->startup)
    (*base->startup)(self);
}
void Application_Class::activate_callback(GApplication* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_activate();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->activate)
    (*base->activate)(self);
}


Glib::ObjectBase* Application_Class::wrap_new(GObject* object)
{
  return new Application((GApplication*)object);
}


/* The implementation: */

GApplication* Application::gobj_copy()
{
  reference();
  return gobj();
}

Application::Application(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Application::Application(GApplication* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Application::~Application()
{}


Application::CppClassType Application::application_class_; // initialize static member

GType Application::get_type()
{
  return application_class_.init().get_type();
}


GType Application::get_base_type()
{
  return g_application_get_type();
}


Application::Application()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(application_class_.init()))
{
  

}

Glib::RefPtr<Application> Application::create(const Glib::ustring& appid, ApplicationFlags flags)
{
  return Glib::wrap(g_application_new(appid.c_str(), ((GApplicationFlags)(flags))));
}


bool Application::id_is_valid(const Glib::ustring& application_id)
{
  return g_application_id_is_valid(application_id.c_str());
}


Glib::ustring Application::get_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_application_get_application_id(const_cast<GApplication*>(gobj())));
}

void Application::set_id(const Glib::ustring& application_id)
{
g_application_set_application_id(gobj(), application_id.c_str()); 
}

guint Application::get_inactivity_timeout() const
{
  return g_application_get_inactivity_timeout(const_cast<GApplication*>(gobj()));
}

void Application::set_inactivity_timeout(guint inactivity_timeout)
{
g_application_set_inactivity_timeout(gobj(), inactivity_timeout); 
}

ApplicationFlags Application::get_flags() const
{
  return ((ApplicationFlags)(g_application_get_flags(const_cast<GApplication*>(gobj()))));
}

void Application::set_flags(ApplicationFlags flags)
{
g_application_set_flags(gobj(), ((GApplicationFlags)(flags))); 
}

void Application::set_action_group(const Glib::RefPtr<ActionGroup>& action_group)
{
g_application_set_action_group(gobj(), Glib::unwrap(action_group)); 
}

bool Application::is_registered() const
{
  return g_application_get_is_registered(const_cast<GApplication*>(gobj()));
}

bool Application::is_remote() const
{
  return g_application_get_is_remote(const_cast<GApplication*>(gobj()));
}

bool Application::register_application(const Glib::RefPtr<Gio::Cancellable>& cancellable)
{
  GError* gerror = 0;
  bool retvalue = g_application_register(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void Application::hold()
{
g_application_hold(gobj()); 
}

void Application::release()
{
g_application_release(gobj()); 
}

void Application::activate()
{
g_application_activate(gobj()); 
}

void Application::run(int argc, char** argv)
{
g_application_run(gobj(), argc, argv); 
}


Glib::SignalProxy0< void > Application::signal_startup()
{
  return Glib::SignalProxy0< void >(this, &Application_signal_startup_info);
}


Glib::SignalProxy0< void > Application::signal_activate()
{
  return Glib::SignalProxy0< void >(this, &Application_signal_activate_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> > Application::property_action_group() 
{
  return Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> >(this, "action-group");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Application::property_application_id() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "application-id");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Application::property_application_id() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "application-id");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<ApplicationFlags> Application::property_flags() 
{
  return Glib::PropertyProxy<ApplicationFlags>(this, "flags");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<ApplicationFlags> Application::property_flags() const
{
  return Glib::PropertyProxy_ReadOnly<ApplicationFlags>(this, "flags");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint> Application::property_inactivity_timeout() 
{
  return Glib::PropertyProxy<guint>(this, "inactivity-timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Application::property_inactivity_timeout() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "inactivity-timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Application::property_is_registered() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "is-registered");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Application::property_is_remote() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "is-remote");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gio::Application::on_startup()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->startup)
    (*base->startup)(gobj());
}
void Gio::Application::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
    (*base->activate)(gobj());
}


} // namespace Gio


