// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _ATKMM_EDITABLETEXT_H
#define _ATKMM_EDITABLETEXT_H


#include <glibmm.h>

/* $Id: editabletext.hg,v 1.2 2004/01/02 09:56:43 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/text.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkEditableTextIface AtkEditableTextIface;
  typedef struct _AtkEditableText      AtkEditableText;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkEditableText AtkEditableText;
typedef struct _AtkEditableTextClass AtkEditableTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{ class EditableText_Class; } // namespace Atk
namespace Atk
{

//TODO: I see no evidence that AtkEditableText is actually a subclass of AtkText, as the C docs say. murrayc.
/* The ATK interface implemented by components containing user-editable text content.
 * This should be implemented by UI components which contain text which the user can edit, via the Atk::Object
 * corresponding to that component (see Atk::Object).
 * EditableText is a subclass of AtkText, and as such, an object which implements EditableText is by definition
 * an Atk::Text implementor as well. 
 */

class EditableText : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef EditableText CppObjectType;
  typedef EditableText_Class CppClassType;
  typedef AtkEditableText BaseObjectType;
  typedef AtkEditableTextIface BaseClassType;

private:
  friend class EditableText_Class;
  static CppClassType editabletext_class_;

  // noncopyable
  EditableText(const EditableText&);
  EditableText& operator=(const EditableText&);

protected:
  EditableText(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit EditableText(AtkEditableText* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~EditableText();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkEditableText*       gobj()       { return reinterpret_cast<AtkEditableText*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const AtkEditableText* gobj() const { return reinterpret_cast<AtkEditableText*>(gobject_); }

private:


public:
  
  /** Sets the attributes for a specified range. See the ATK_ATTRIBUTE
   * macros (such as Atk::ATTRIBUTE_LEFT_MARGIN) for examples of attributes 
   * that can be set. Note that other attributes that do not have corresponding
   * ATK_ATTRIBUTE macros may also be set for certain text widgets.
   * @param attrib_set An Atk::AttributeSet.
   * @param start_offset Start of range in which to set attributes.
   * @param end_offset End of range in which to set attributes.
   * @return <tt>true</tt> if attributes successfully set for the specified
   * range, otherwise <tt>false</tt>.
   */
  bool set_run_attributes(const AttributeSet& attrib_set, int start_offset, int end_offset);
  
  /** Set text contents of @a text .
   * @param string String to set for text contents of @a text .
   */
  void set_text_contents(const Glib::ustring& string);
  
  /** Insert text at a given position.
   * @param string The text to insert.
   * @param length The length of text to insert, in bytes.
   * @param position The caller initializes this to 
   * the position at which to insert the text. After the call it
   * points at the position after the newly inserted text.
   */
  void insert_text(const Glib::ustring& string, int length, int& position);
  
  /** Copy text from @a start_pos  up to, but not including @a end_pos  
   * to the clipboard.
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void copy_text(int start_pos, int end_pos);
  
  /** Copy text from @a start_pos  up to, but not including @a end_pos 
   * to the clipboard and then delete from the widget.
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void cut_text(int start_pos, int end_pos);
  
  /** Delete text @a start_pos  up to, but not including @a end_pos .
   * @param start_pos Start position.
   * @param end_pos End position.
   */
  void delete_text(int start_pos, int end_pos);
  
  /** Paste text from clipboard to specified @a position .
   * @param position Position to paste.
   */
  void paste_text(int position);

protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_run_attributes_vfunc(AtkAttributeSet* attrib_set, int start_offset, int end_offset);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_text_contents_vfunc(const Glib::ustring& string);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void insert_text_vfunc(const Glib::ustring& string, int length, int& position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void copy_text_vfunc(int start_pos, int end_pos);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void cut_text_vfunc(int start_pos, int end_pos);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void delete_text_vfunc(int start_pos, int end_pos);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void paste_text_vfunc(int position);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::EditableText
   */
  Glib::RefPtr<Atk::EditableText> wrap(AtkEditableText* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_EDITABLETEXT_H */

