// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_MOUNT_H
#define _GIOMM_MOUNT_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <giomm/drive.h>
#include <giomm/file.h>
#include <giomm/volume.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GMountIface GMountIface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GMount GMount;
typedef struct _GMountClass GMountClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Mount_Class; } // namespace Gio
namespace Gio
{

class Drive;
//class Volume;

/** TODO: 
 *
 * @newin2p16
 */

class Mount : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Mount CppObjectType;
  typedef Mount_Class CppClassType;
  typedef GMount BaseObjectType;
  typedef GMountIface BaseClassType;

private:
  friend class Mount_Class;
  static CppClassType mount_class_;

  // noncopyable
  Mount(const Mount&);
  Mount& operator=(const Mount&);

protected:
  Mount(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Mount(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Mount(GMount* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Mount();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GMount*       gobj()       { return reinterpret_cast<GMount*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GMount* gobj() const { return reinterpret_cast<GMount*>(gobject_); }

private:


public:

  
  /** Gets the root directory on @a mount.
   * @return A File.
   */
  Glib::RefPtr<File> get_root();
  
  /** Gets the root directory on @a mount.
   * @return A File.
   */
  Glib::RefPtr<const File> get_root() const;

  
  /** Gets the name of @a mount.
   * @return The name for the given @a mount. The returned string should 
   * be freed when no longer needed.
   */
  std::string get_name() const;

  
  /** Gets the icon for @a mount.
   * @return A Icon.
   */
  Glib::RefPtr<Icon> get_icon();
  
  /** Gets the icon for @a mount.
   * @return A Icon.
   */
  Glib::RefPtr<const Icon> get_icon() const;

  
  /** Gets the UUID for the @a mount. The reference is typically based on
   * the file system UUID for the mount in question and should be
   * considered an opaque string. Returns <tt>0</tt> if there is no UUID
   * available.
   * @return The UUID for @a mount or <tt>0</tt> if no UUID can be computed.
   */
  std::string get_uuid() const;

  
  /** Gets the volume for the @a mount.
   * @return A Volume or <tt>0</tt> if @a mount is not associated with a volume.
   */
  Glib::RefPtr<Volume> get_volume();
  
  /** Gets the volume for the @a mount.
   * @return A Volume or <tt>0</tt> if @a mount is not associated with a volume.
   */
  Glib::RefPtr<const Volume> get_volume() const;

  
  /** Gets the drive for the @a mount.
   * 
   * This is a convenience method for getting the Volume and then
   * using that object to get the Drive.
   * @return A Drive or <tt>0</tt> if @a mount is not associated with a volume or a drive.
   */
  Glib::RefPtr<Drive> get_drive();
  
  /** Gets the drive for the @a mount.
   * 
   * This is a convenience method for getting the Volume and then
   * using that object to get the Drive.
   * @return A Drive or <tt>0</tt> if @a mount is not associated with a volume or a drive.
   */
  Glib::RefPtr<const Drive> get_drive() const;

  
  /** Checks if @a mount can be mounted.
   * @return <tt>true</tt> if the @a mount can be unmounted.
   */
  bool can_unmount() const;
  
  /** Checks if @a mount can be eject.
   * @return <tt>true</tt> if the @a mount can be ejected.
   */
  bool can_eject() const;

  /** Unmounts a mount. 
   * This is an asynchronous operation, and is finished by calling unmount_finish() with the AsyncResult data returned in the callback slot.
   *
   * @param slot A callback which will be called when the operation is completed or canceled.
   * @param cancellable A cancellable object which can be used to cancel the operation.
   * @param flags Flags affecting the unmount.
   */
  void unmount(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Unmounts a mount. 
   * This is an asynchronous operation, and is finished by calling unmount_finish() with the AsyncResult data returned in the callback slot.
   *
   * @param slot A callback which will be called when the operation is completed or canceled.
   * @param flags Flags affecting the unmount.
   */
  void unmount(const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Unmounts a mount.
   *
   * @param cancellable A cancellable object which can be used to cancel the operation.
   */
  void unmount(MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  

  /** Finishes unmounting a mount. If any errors occured during the operation, 
   *  @a error will be set to contain the errors and <tt>false</tt> will be returned.
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the mount was successfully unmounted. <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool unmount_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool unmount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Remounts a mount.
   * This is an asynchronous operation, and is finished by calling mount_finish() with the AsyncResult data returned in the callback slot.
   *
   * Remounting is useful when some setting affecting the operation of the volume has been changed, as this may need a remount 
   * to take affect. While this is semantically equivalent with unmounting and then remounting, not all backends might need to 
   * actually be unmounted.
   *
   * @param operation A mount operation.
   * @param slot A callback which will be called when the operation is completed or canceled.
   * @param cancellable A cancellable object which can be used to cancel the operation.
   */
  void remount(const Glib::RefPtr<MountOperation>& operation, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountMountFlags flags = MOUNT_MOUNT_NONE);

  /** Remounts a mount.
   * This is an asynchronous operation, and is finished by calling mount_finish() with the AsyncResult data returned in the callback slot.
   *
   * Remounting is useful when some setting affecting the operation of the volume has been changed, as this may need a remount 
   * to take affect. While this is semantically equivalent with unmounting and then remounting, not all backends might need to 
   * actually be unmounted.
   *
   * @param operation A mount operation.
   * @param slot A callback which will be called when the operation is completed or canceled.
   */
  void remount(const Glib::RefPtr<MountOperation>& operation, const SlotAsyncReady& slot, MountMountFlags flags = MOUNT_MOUNT_NONE);

  /** Remounts a mount.
   * 
   * Remounting is useful when some setting affecting the operation of the volume has been changed, as this may need a remount 
   * to take affect. While this is semantically equivalent with unmounting and then remounting, not all backends might need to 
   * actually be unmounted.
   *
   * @param operation A mount operation.
   */
  void remount(const Glib::RefPtr<MountOperation>& operation, MountMountFlags flags = MOUNT_MOUNT_NONE);

  /** Remounts a mount, without user interaction.
   * 
   * Remounting is useful when some setting affecting the operation of the volume has been changed, as this may need a remount 
   * to take affect. While this is semantically equivalent with unmounting and then remounting, not all backends might need to 
   * actually be unmounted.
   */
  void remount(MountMountFlags flags = MOUNT_MOUNT_NONE);
  

  /** Finishes remounting a mount. If any errors occured during the operation, 
   *  @a error will be set to contain the errors and <tt>false</tt> will be returned.
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the mount was successfully remounted. <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remount_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool remount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Ejects a mount. 
   * This is an asynchronous operation, and is finished by calling eject_finish() with the AsyncResult data returned in the callback slot.
   *
   * @param slot A callback which will be called when the operation is completed or canceled.
   * @param cancellable A cancellable object which can be used to cancel the operation.
   * @param flags Flags affecting the unmount if required for eject.
   */
  void eject(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Ejects a mount. 
   * This is an asynchronous operation, and is finished by calling eject_finish() with the AsyncResult data returned in the callback slot.
   *
   * @param slot A callback which will be called when the operation is completed or canceled.
   * @param flags Flags affecting the unmount if required for eject.
   */
  void eject(const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Ejects a mount. 
   *
   * @param flags Flags affecting the unmount if required for eject.
   */
  void eject(MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  

  /** Finishes ejecting a mount. If any errors occured during the operation, 
   *  @a error will be set to contain the errors and <tt>false</tt> will be returned.
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the mount was successfully ejected. <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool eject_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool eject_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: For some reason these are not in gio_signals.defs. We may need to hand-write them in gio_others.defs. murrayc.
  //gtkmmproc error: changed :  signal defs lookup failed
  //gtkmmproc error: unmounted :  signal defs lookup failed

  //There are no properties.

  //TODO: vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Mount
   */
  Glib::RefPtr<Gio::Mount> wrap(GMount* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_MOUNT_H */

