/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "gtk_java.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventButton_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, (GObject *)obj_g->window);
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventButton_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jboolean) obj_g->send_event;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return obj_g->time;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getX
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getX (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) obj_g->x;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getY
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getY (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) obj_g->y;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getState (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jint) obj_g->state;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getButton
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventButton_getButton (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jint) obj_g->button;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getDevice
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventButton_getDevice (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, (GObject *)obj_g->device);
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getXRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getXRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) obj_g->x_root;
}

/*
 * Class:     org.gnu.gdk.EventButton
 * Method:    getYRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventButton_getYRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventButton *obj_g = (GdkEventButton *)getPointerFromHandle(env, obj);
    return (jdouble) obj_g->y_root;
}


#ifdef __cplusplus
}

#endif
