# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=jpeg
VER=7
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

CC='gcc -mtune=pentium3 -mthreads' \
CFLAGS=-O2 \
./configure \
--disable-static \
--prefix=$TARGET &&

make install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/libjpeg-7.dll &&
zip /tmp/$DEVZIP bin/*.exe &&
zip /tmp/$DEVZIP lib/*.dll.a &&
zip -r -D /tmp/$DEVZIP include share

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
