/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.stax2.ri.typed;

import java.math.BigInteger;
import org.jetbrains.kotlin.org.codehaus.stax2.typed.TypedValueDecoder;

public final class ValueDecoderFactory {
    protected BooleanDecoder mBooleanDecoder = null;
    protected IntDecoder mIntDecoder = null;
    protected LongDecoder mLongDecoder = null;
    protected FloatDecoder mFloatDecoder = null;
    protected DoubleDecoder mDoubleDecoder = null;

    public BooleanDecoder getBooleanDecoder() {
        if (this.mBooleanDecoder == null) {
            this.mBooleanDecoder = new BooleanDecoder();
        }
        return this.mBooleanDecoder;
    }

    public IntDecoder getIntDecoder() {
        if (this.mIntDecoder == null) {
            this.mIntDecoder = new IntDecoder();
        }
        return this.mIntDecoder;
    }

    public static final class DoubleDecoder
    extends DecoderBase {
        protected double mValue;

        @Override
        public String getType() {
            return "double";
        }

        @Override
        public void decode(char[] lexical, int start, int end) throws IllegalArgumentException {
            char c;
            int len = end - start;
            if (len == 3) {
                c = lexical[start];
                if (c == 'I') {
                    if (lexical[start + 1] == 'N' && lexical[start + 2] == 'F') {
                        this.mValue = Double.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c == 'N' && lexical[start + 1] == 'a' && lexical[start + 2] == 'N') {
                    this.mValue = Double.NaN;
                    return;
                }
            } else if (len == 4 && (c = lexical[start]) == '-' && lexical[start + 1] == 'I' && lexical[start + 2] == 'N' && lexical[start + 3] == 'F') {
                this.mValue = Double.NEGATIVE_INFINITY;
                return;
            }
            String lexicalStr = new String(lexical, start, len);
            try {
                this.mValue = Double.parseDouble(lexicalStr);
            }
            catch (NumberFormatException nex) {
                throw this.constructInvalidValue(lexicalStr);
            }
        }
    }

    public static final class FloatDecoder
    extends DecoderBase {
        protected float mValue;

        @Override
        public String getType() {
            return "float";
        }

        @Override
        public void decode(char[] lexical, int start, int end) throws IllegalArgumentException {
            char c;
            int len = end - start;
            if (len == 3) {
                c = lexical[start];
                if (c == 'I') {
                    if (lexical[start + 1] == 'N' && lexical[start + 2] == 'F') {
                        this.mValue = Float.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c == 'N' && lexical[start + 1] == 'a' && lexical[start + 2] == 'N') {
                    this.mValue = Float.NaN;
                    return;
                }
            } else if (len == 4 && (c = lexical[start]) == '-' && lexical[start + 1] == 'I' && lexical[start + 2] == 'N' && lexical[start + 3] == 'F') {
                this.mValue = Float.NEGATIVE_INFINITY;
                return;
            }
            String lexicalStr = new String(lexical, start, len);
            try {
                this.mValue = Float.parseFloat(lexicalStr);
            }
            catch (NumberFormatException nex) {
                throw this.constructInvalidValue(lexicalStr);
            }
        }
    }

    public static final class LongDecoder
    extends DecoderBase {
        protected long mValue;

        @Override
        public String getType() {
            return "long";
        }

        @Override
        public void decode(char[] lexical, int start, int end) throws IllegalArgumentException {
            char ch = lexical[start];
            boolean neg = ch == '-';
            int nr = neg || ch == '+' ? this.skipSignAndZeroes(lexical, ch, true, start, end) : this.skipSignAndZeroes(lexical, ch, false, start, end);
            int ptr = this.mNextPtr;
            int charsLeft = end - ptr;
            if (charsLeft == 0) {
                this.mValue = neg ? -nr : nr;
                return;
            }
            this.verifyDigits(lexical, start, end, ptr);
            if (charsLeft <= 8) {
                int i = LongDecoder.parseInt(nr, lexical, ptr, ptr + charsLeft);
                this.mValue = neg ? (long)(-i) : (long)i;
                return;
            }
            --ptr;
            if (++charsLeft <= 18) {
                long l = LongDecoder.parseLong(lexical, ptr, ptr + charsLeft);
                this.mValue = neg ? -l : l;
                return;
            }
            this.mValue = this.parseUsingBD(new String(lexical, ptr, charsLeft), neg);
        }

        private long parseUsingBD(String lexical, boolean neg) {
            BigInteger bi = new BigInteger(lexical);
            if (neg ? (bi = bi.negate()).compareTo(BD_MIN_LONG) >= 0 : bi.compareTo(BD_MAX_LONG) <= 0) {
                return bi.longValue();
            }
            throw new IllegalArgumentException("value \"" + this.lexicalDesc(lexical) + "\" not a valid long: overflow.");
        }
    }

    public static final class IntDecoder
    extends DecoderBase {
        protected int mValue;

        @Override
        public String getType() {
            return "int";
        }

        public int getValue() {
            return this.mValue;
        }

        @Override
        public void decode(char[] lexical, int start, int end) throws IllegalArgumentException {
            char ch = lexical[start];
            boolean neg = ch == '-';
            int nr = neg || ch == '+' ? this.skipSignAndZeroes(lexical, ch, true, start, end) : this.skipSignAndZeroes(lexical, ch, false, start, end);
            int ptr = this.mNextPtr;
            int charsLeft = end - ptr;
            if (charsLeft == 0) {
                this.mValue = neg ? -nr : nr;
                return;
            }
            this.verifyDigits(lexical, start, end, ptr);
            if (charsLeft <= 8) {
                int i = IntDecoder.parseInt(nr, lexical, ptr, ptr + charsLeft);
                this.mValue = neg ? -i : i;
                return;
            }
            if (charsLeft == 9 && nr < 3) {
                long base = 1000000000L;
                if (nr == 2) {
                    base += 1000000000L;
                }
                int i = IntDecoder.parseInt(lexical, ptr, ptr + charsLeft);
                long l = base + (long)i;
                if (neg) {
                    if ((l = -l) >= Integer.MIN_VALUE) {
                        this.mValue = (int)l;
                        return;
                    }
                } else if (l <= Integer.MAX_VALUE) {
                    this.mValue = (int)l;
                    return;
                }
            }
            throw new IllegalArgumentException("value \"" + this.lexicalDesc(lexical, start, end) + "\" not a valid 32-bit integer: overflow.");
        }
    }

    public static final class BooleanDecoder
    extends DecoderBase {
        protected boolean mValue;

        @Override
        public String getType() {
            return "boolean";
        }

        public boolean getValue() {
            return this.mValue;
        }

        @Override
        public void decode(char[] lexical, int start, int end) throws IllegalArgumentException {
            int len = end - start;
            char c = lexical[start];
            if (c == 't') {
                if (len == 4 && lexical[start + 1] == 'r' && lexical[start + 2] == 'u' && lexical[start + 3] == 'e') {
                    this.mValue = true;
                    return;
                }
            } else if (c == 'f') {
                if (len == 5 && lexical[start + 1] == 'a' && lexical[start + 2] == 'l' && lexical[start + 3] == 's' && lexical[start + 4] == 'e') {
                    this.mValue = false;
                    return;
                }
            } else if (c == '0') {
                if (len == 1) {
                    this.mValue = false;
                    return;
                }
            } else if (c == '1' && len == 1) {
                this.mValue = true;
                return;
            }
            throw this.constructInvalidValue(lexical, start, end);
        }
    }

    public static abstract class DecoderBase
    extends TypedValueDecoder {
        static final BigInteger BD_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        static final BigInteger BD_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        protected int mNextPtr;

        protected DecoderBase() {
        }

        public abstract String getType();

        @Override
        public void handleEmptyValue() {
            throw new IllegalArgumentException("Empty value (all white space) not a valid lexical representation of " + this.getType());
        }

        protected void verifyDigits(char[] lexical, int start, int end, int ptr) {
            while (ptr < end) {
                char ch = lexical[ptr];
                if (ch > '9' || ch < '0') {
                    throw this.constructInvalidValue(lexical, start, end);
                }
                ++ptr;
            }
        }

        protected int skipSignAndZeroes(char[] lexical, char ch, boolean hasSign, int start, int end) {
            int v2;
            int value2;
            int ptr = start + 1;
            if (hasSign) {
                if (ptr >= end) {
                    throw this.constructInvalidValue(lexical, start, end);
                }
                ch = lexical[ptr++];
            }
            if ((value2 = ch - 48) < 0 || value2 > 9) {
                throw this.constructInvalidValue(lexical, start, end);
            }
            while (value2 == 0 && ptr < end && (v2 = lexical[ptr] - 48) >= 0 && v2 <= 9) {
                ++ptr;
                value2 = v2;
            }
            this.mNextPtr = ptr;
            return value2;
        }

        protected static final int parseInt(char[] digitChars, int start, int end) {
            int num = digitChars[start] - 48;
            if (++start < end) {
                num = num * 10 + (digitChars[start] - 48);
                if (++start < end) {
                    num = num * 10 + (digitChars[start] - 48);
                    if (++start < end) {
                        num = num * 10 + (digitChars[start] - 48);
                        if (++start < end) {
                            num = num * 10 + (digitChars[start] - 48);
                            if (++start < end) {
                                num = num * 10 + (digitChars[start] - 48);
                                if (++start < end) {
                                    num = num * 10 + (digitChars[start] - 48);
                                    if (++start < end) {
                                        num = num * 10 + (digitChars[start] - 48);
                                        if (++start < end) {
                                            num = num * 10 + (digitChars[start] - 48);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return num;
        }

        protected static final int parseInt(int num, char[] digitChars, int start, int end) {
            num = num * 10 + (digitChars[start] - 48);
            if (++start < end) {
                num = num * 10 + (digitChars[start] - 48);
                if (++start < end) {
                    num = num * 10 + (digitChars[start] - 48);
                    if (++start < end) {
                        num = num * 10 + (digitChars[start] - 48);
                        if (++start < end) {
                            num = num * 10 + (digitChars[start] - 48);
                            if (++start < end) {
                                num = num * 10 + (digitChars[start] - 48);
                                if (++start < end) {
                                    num = num * 10 + (digitChars[start] - 48);
                                    if (++start < end) {
                                        num = num * 10 + (digitChars[start] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return num;
        }

        protected static final long parseLong(char[] digitChars, int start, int end) {
            int start2 = end - 9;
            long val = (long)DecoderBase.parseInt(digitChars, start, start2) * 1000000000L;
            return val + (long)DecoderBase.parseInt(digitChars, start2, end);
        }

        protected IllegalArgumentException constructInvalidValue(String lexical) {
            return new IllegalArgumentException("Value \"" + lexical + "\" not a valid lexical representation of " + this.getType());
        }

        protected IllegalArgumentException constructInvalidValue(char[] lexical, int startOffset, int end) {
            return new IllegalArgumentException("Value \"" + this.lexicalDesc(lexical, startOffset, end) + "\" not a valid lexical representation of " + this.getType());
        }

        protected String lexicalDesc(char[] lexical, int startOffset, int end) {
            return this._clean(new String(lexical, startOffset, end - startOffset));
        }

        protected String lexicalDesc(String lexical) {
            return this._clean(lexical);
        }

        protected String _clean(String str) {
            return str.trim();
        }
    }
}

