/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.views.InspectorContentSection;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;

public class HyperlinkInspectorSection
extends InspectorContentSection
implements ICoreEventListener {
    private ICoreEventRegister register;
    private List<ITopic> topicsWithHyperlink;
    private List<ITopic> allTopics;

    public HyperlinkInspectorSection() {
        this.setTitle(NLS.bind((String)Messages.HyperlinkInspectorSection_title, (Object)0));
    }

    @Override
    protected void refreshList() {
        super.refreshList();
        if (this.topicsWithHyperlink != null) {
            this.setTitle(NLS.bind((String)Messages.HyperlinkInspectorSection_title, (Object)this.topicsWithHyperlink.size()));
        } else {
            this.setTitle(NLS.bind((String)Messages.HyperlinkInspectorSection_title, (Object)0));
        }
    }

    @Override
    protected Object[] getAllPropertyContents(IGraphicalViewer viewer) {
        List<ITopic> topicsWithHyperlink = null;
        List<ITopic> allTopics = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            allTopics = this.getAllTopics();
            topicsWithHyperlink = this.getTopicsWithHyperlink(allTopics);
        }
        this.setLabelRef(topicsWithHyperlink, allTopics);
        if (topicsWithHyperlink != null) {
            return topicsWithHyperlink.toArray();
        }
        return new Object[0];
    }

    private void setLabelRef(List<ITopic> topicsWithHyperlink, List<ITopic> allTopics) {
        if (topicsWithHyperlink == this.topicsWithHyperlink && allTopics == this.allTopics) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.topicsWithHyperlink = topicsWithHyperlink;
        this.allTopics = allTopics;
        if (allTopics != null) {
            this.register = new CoreEventRegister((Object)this.getCurrentWorkbook(), (ICoreEventListener)this);
            this.register.register("modifyTime");
        }
    }

    private List<ITopic> getTopicsWithHyperlink(List<ITopic> all) {
        ArrayList<ITopic> topics = null;
        for (ITopic topic : all) {
            if (!this.hasHyperlink(topic)) continue;
            if (topics == null) {
                topics = new ArrayList<ITopic>();
            }
            topics.add(topic);
        }
        return topics;
    }

    private boolean hasHyperlink(ITopic topic) {
        return topic.getHyperlink() != null && !topic.getHyperlink().startsWith("xap:") && !topic.getHyperlink().startsWith("file:");
    }

    @Override
    protected Image getPropertyInspectorImage(Object element) {
        return MindMapUI.getImages().get("hyperlink.png", true).createImage();
    }

    @Override
    protected String getPropertyInspectorText(Object element) {
        if (element instanceof ITopic) {
            return String.valueOf(((ITopic)element).getTitleText().replaceAll("\r\n|\r|\n", " ")) + "[topic+link]" + ((ITopic)element).getHyperlink();
        }
        return null;
    }

    public String getPropertyInspectorHyperlink(Object element) {
        if (element instanceof ITopic) {
            return ((ITopic)element).getHyperlink();
        }
        return null;
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                HyperlinkInspectorSection.this.refreshList(event);
            }
        });
    }

    protected void refreshList(CoreEvent event) {
        this.refreshList();
        this.getControl().getParent().layout();
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }
}

