/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.viewers.MButton;

public abstract class MEmbeddedEditor {
    private Composite composite;
    private MButton button;
    private Composite editorWrap;
    private StackLayout stack;
    private ListenerList editorListeners = new ListenerList();

    public MEmbeddedEditor(Composite parent) {
        this(parent, 0);
        this.hideEditor();
    }

    public MEmbeddedEditor(Composite parent, int buttonStyle) {
        this.createControl(parent, buttonStyle);
        this.hideEditor();
    }

    private void createControl(Composite parent, int buttonStyle) {
        parent = this.createContainer(parent);
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        this.stack = new StackLayout();
        this.composite.setLayout((Layout)this.stack);
        this.createButton(this.composite, buttonStyle);
        this.createWrap(this.composite);
    }

    protected Composite createContainer(Composite parent) {
        return parent;
    }

    private void createButton(Composite parent, int buttonStyle) {
        this.button = new MButton(parent, buttonStyle);
        this.button.getControl().setBackground(parent.getBackground());
        this.button.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MEmbeddedEditor.this.startEditing();
            }
        });
    }

    private void createWrap(Composite parent) {
        this.editorWrap = new Composite(parent, 0);
        this.editorWrap.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.editorWrap.setLayout((Layout)gridLayout);
        this.createEditor(this.editorWrap);
    }

    protected abstract void createEditor(Composite var1);

    public Control getControl() {
        return this.composite;
    }

    public MButton getButton() {
        return this.button;
    }

    public void startEditing() {
        this.showEditor();
        this.setFocus();
    }

    protected void showEditor() {
        this.stack.topControl = this.editorWrap;
        this.button.getControl().setVisible(false);
        this.editorWrap.setVisible(true);
        this.composite.layout();
        this.editorWrap.layout();
    }

    protected void hideEditor() {
        this.stack.topControl = this.button.getControl();
        this.button.getControl().setVisible(true);
        this.editorWrap.setVisible(false);
        this.composite.layout();
        this.editorWrap.layout();
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.fireCancelEditor();
        }
        this.hideEditor();
    }

    public void endEditing() {
        if (this.isEditing()) {
            this.fireApplyEditorValue();
        }
        this.hideEditor();
    }

    public boolean isEditing() {
        return this.stack.topControl == this.editorWrap;
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.isEditing()) {
            this.setEditorFocus();
        } else {
            this.button.getControl().setFocus();
        }
    }

    protected abstract void setEditorFocus();

    public void addEditorListener(ICellEditorListener listener) {
        this.editorListeners.add((Object)listener);
    }

    public void removeEditorListener(ICellEditorListener listener) {
        this.editorListeners.remove((Object)listener);
    }

    protected void fireApplyEditorValue() {
        Object[] listeners = this.editorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ICellEditorListener l = (ICellEditorListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    l.applyEditorValue();
                }
            });
            ++i;
        }
    }

    protected void fireCancelEditor() {
        Object[] listeners = this.editorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ICellEditorListener l = (ICellEditorListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    l.cancelEditor();
                }
            });
            ++i;
        }
    }

    protected void endEditingWhenFocusOut() {
        if (!this.isEditing() || this.editorWrap.isDisposed() || !this.hasFocus((Control)this.editorWrap)) {
            return;
        }
        Display.getCurrent().timerExec(10, new Runnable(){

            @Override
            public void run() {
                if (MEmbeddedEditor.this.editorWrap.isDisposed()) {
                    return;
                }
                if (!MEmbeddedEditor.this.hasFocus((Control)MEmbeddedEditor.this.editorWrap)) {
                    MEmbeddedEditor.this.endEditing();
                }
            }
        });
    }

    private boolean hasFocus(Control control) {
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.isFocusControl()) {
                    return true;
                }
                if (child instanceof Composite && this.hasFocus((Control)((Composite)child))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

