table mgcFullength
"table of fullength purified clones"
    (
    int id_clone;           "MGC clone id"
    int id_vendor;          "id of clone arrayer"
    string plate;           "plate id of clone"
    string row;             "row of clone"
    int col;                "col of clone"
    int id_parent;          "id of parent clone"
    string clone_sent;      "date sent out for sequencing"
    string seq_back;        "date sequence received"
    int id_sequencer;       "id of clone sequencer"
    byte seq_verified;      "5' and 3` sequence confirm 2=yes; 0=unknown, 1 = no, 3 = ambiguous"
    byte colony_pure;       "1=no, 2=yes"
    int id_purif;           "id of clone purifier"
    byte full_length;       "1=no, 2=yes, 0 = unknown"
    string gb_acc;          "genbank accession"
    lstring why_full;       "reason for deciding if full length"
    byte known;             "known gene? 1=no 2 = yes"
    int cdstart;            "start of coding region negative means incomplete; 0 at both start and stop means couldn't choose a CDS"
    int cdstop;             "end of coding region"
    string pr_acc;          "protein accession"
    byte dump_seq;          "flag to dump entry, 1 = no, 2=dump to lukas in FASTA; 3 = dump to ASN.1 with CDS - complete, 4 = dump to ASN.1 with CDS - incomplete; 5 = dump to ASN.1 problem file without CDS"
    string series;          "plate series"
    string organism;        "organism name"
    byte orient;            "strand of CDS 1 = +ve, 0 = -ve"
    string defline;         "GenBank definition line"
    int locuslink;          "locus link id for dbxref"
    byte commnt;            "comment about clone"
    byte pass;              "sequence quality"
    string genesymbol;      "NM accession"
    byte by_indexer;        "flag for hand annotation; 1=yes, null= no"
    )
