# hapmapSnps.sql was originally generated by the autoSql program, which also 
# generated hapmapSnps.c and hapmapAlleles.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#HapMap genotype summary
CREATE TABLE hapmapSnps (
    bin int unsigned not null,				# For browser speed up
    chrom varchar(255) not null,			# Chromosome
    chromStart int unsigned not null,			# Start position in chrom (0 based)
    chromEnd int unsigned not null,			# End position in chrom (1 based)
    name varchar(255) not null,				# Reference SNP identifier from dbSnp
    score int unsigned not null,			# Minor allele frequency (0-500) 
    strand enum ('+', '-', '?') default '?' not null,	# Which genomic strand contains the observed alleles
    observed varchar(255) not null,			# Observed string from genotype file
    allele1 enum('A', 'C', 'G', 'T')  not null,		# This allele has been observed
    homoCount1 int unsigned not null,			# Count of individuals who are homozygous for allele1
    allele2 enum('C', 'G', 'T', 'none') not null,	# This allele may not have been observed
    homoCount2 int unsigned not null,			# Count of individuals who are homozygous for allele2
    heteroCount int unsigned not null,			# Count of individuals who are heterozygous
              #Indices
    INDEX name (name),
    INDEX chrom (chrom, bin)
);
