#!/usr/bin/ruby -w

# encodeUnload.rb - unload ENCODE data submission generated by the
#                       automated submission pipeline
# Reads load.ra for information about what to do

# Writes error or log information to STDOUT
# Returns 0 if unload succeeds.

# DO NOT EDIT the /cluster/bin/scripts copy of this file -- 
# edit the CVS'ed source at:
# $Header: /projects/compbio/cvsroot/kent/src/hg/encode/encodeUnload/doEncodeUnload.rb,v 1.4 2008/03/05 23:09:06 galt Exp $

$scripts = "/cluster/bin/scripts"

require "#{$scripts}/err.rb"
require "#{$scripts}/verbose.rb"
require "#{$scripts}/ra.rb"
require 'tempfile'

# Global constants

# Global variables
$unloadRa = 'out/unload.ra'
$submitDir = ""
$submitType = ""
$tempDir = "/data/tmp"
$encodeDb = "hg18"
$encInstance = ""

def usage 
    errAbort "usage: doEncodeUnload.rb submission_type project_submission_dir\n"
end

def execResults(cmd)
  temp_file = Tempfile.new('results')

  #STDOUT.puts "temp_file.path = #{temp_file.path}"  # DEBUG
  #STDOUT.puts "cmd  = [#{cmd}]"  # DEBUG

  unless system( "#{cmd} > #{temp_file.path} 2>&1" )
    errAbort "unexpected error running command #{cmd}"
  end
  result = File.read temp_file.path
  temp_file.close
  #STDOUT.puts "result = [#{result}]"  # DEBUG
  return result
end

def tableExist?(db, tableName)
  result =  execResults( "hgsql #{db} -BNe 'show tables like \"#{tableName}\"'" )
  #STDOUT.puts "result = [#{result}]"  # DEBUG
  return result == "#{tableName}\n"
end

def dropTable(db, tableName)
  unless system( "hgsql -e 'drop table #{db}.#{tableName}'" )
    errAbort "unexpected error dropping table #{db}.#{tableName}"
  end
end

def dropTableIfExist(db, tableName)
  if tableExist?(db, tableName)
    STDOUT.puts "table #{db}.#{tableName} exists, dropping it"  # DEBUG
    # drop table
    dropTable db, tableName
  end
end



def unloadGene(tableName)
  
  dropTableIfExist $encodeDb, tableName

end

def unloadWig(tableName)

  dropTableIfExist $encodeDb, tableName

  # remove symlink 
  unless system( "rm -f /gbdb/#{$encodeDb}/wib/#{tableName}.wib" )
    errAbort "unexpected error removing symlink /gbdb/#{$encodeDb}/wib/#{tableName}.wib"
  end
 
end

def unloadBed(tableName)
  
  dropTableIfExist $encodeDb, tableName

end



############################################################################
# Main

# Change dir to submission directory obtained from command-line

if ARGV.length != 2
  usage
end


$submitType = ARGV[0]	# currently not used
$submitDir = ARGV[1]

$encInstance = File.dirname($submitDir)
$encProject = File.basename($submitDir)

und = $encInstance.rindex('_')
if und
  $encInstance = $encInstance[und,$encInstance.length]
else
  $encInstance = ""
end


unless File.exist? $submitDir
  exit 0
end

Dir.chdir $submitDir

unless File.exist? $unloadRa
  exit 0
end

verbose 1, "Unloading project in directory #{$submitDir}\n"

# Unload resources listed in unload.ra

ra = readRaFile $unloadRa
  
ra.each do |x|
  h = x[1]
  tablenameExt = "#{h["tablename"]}#{$encInstance}_#{$encProject}"
  verbose 2, "debug: #{x[0]}\n"  
  verbose 2, "  tablename #{h["tablename"]}\n" 
  verbose 2, "  type      #{h["type"]}\n"  
  verbose 2, "  tableType #{h["tableType"]}\n"  
  verbose 2, "  assembly  #{h["assembly"]}\n" 
  verbose 2, "  files     #{h["files"]}\n"  
  verbose 2, "  tablenameExt #{tablenameExt}\n" 

  # temporary work-around
  $encodeDb = h["assembly"]

  case h["type"]
  when "genePred"
    unloadGene tablenameExt
  when "wig"
    unloadWig tablenameExt
  when "bed 5 +"
    unloadBed tablenameExt
  when "bed 3"
    unloadBed tablenameExt
  when "bed 4"
    unloadBed tablenameExt
  when "bed 5"
    unloadBed tablenameExt
  when "bed 6"
    unloadBed tablenameExt
  else
    errAbort "unexpected error: unknown type #{h["type"]} in unload.ra\n"
  end 
end

exit 0

