/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SaveOrderConfig {
    private static final String ORIGINAL = "original";
    private static final String SPECIFIED = "specified";
    public boolean saveInOriginalOrder;
    public final SortCriterion[] sortCriteria = new SortCriterion[3];

    public SaveOrderConfig() {
        this.setSaveInOriginalOrder();
        this.sortCriteria[0] = new SortCriterion();
        this.sortCriteria[1] = new SortCriterion();
        this.sortCriteria[2] = new SortCriterion();
    }

    public SaveOrderConfig(boolean saveInOriginalOrder, SortCriterion first, SortCriterion second, SortCriterion third) {
        this.saveInOriginalOrder = saveInOriginalOrder;
        this.sortCriteria[0] = first;
        this.sortCriteria[1] = second;
        this.sortCriteria[2] = third;
    }

    private SaveOrderConfig(List<String> data) {
        Objects.requireNonNull(data);
        if (data.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String choice = data.get(0);
        if (ORIGINAL.equals(choice)) {
            this.setSaveInOriginalOrder();
        } else {
            this.setSaveInSpecifiedOrder();
        }
        this.sortCriteria[0] = data.size() >= 3 ? new SortCriterion(data.get(1), data.get(2)) : new SortCriterion();
        this.sortCriteria[1] = data.size() >= 5 ? new SortCriterion(data.get(3), data.get(4)) : new SortCriterion();
        this.sortCriteria[2] = data.size() >= 7 ? new SortCriterion(data.get(5), data.get(6)) : new SortCriterion();
    }

    public static SaveOrderConfig parse(List<String> orderedData) {
        return new SaveOrderConfig(orderedData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SaveOrderConfig) {
            SaveOrderConfig that = (SaveOrderConfig)o;
            boolean sortCriteriaEquals = this.sortCriteria[0].equals(that.sortCriteria[0]) && this.sortCriteria[1].equals(that.sortCriteria[1]) && this.sortCriteria[2].equals(that.sortCriteria[2]);
            return Objects.equals(this.saveInOriginalOrder, that.saveInOriginalOrder) && sortCriteriaEquals;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.saveInOriginalOrder, Arrays.hashCode(this.sortCriteria));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SaveOrderConfig{");
        sb.append("saveInOriginalOrder=").append(this.saveInOriginalOrder);
        sb.append(", sortCriteria=").append(Arrays.toString(this.sortCriteria));
        sb.append('}');
        return sb.toString();
    }

    public void setSaveInOriginalOrder() {
        this.saveInOriginalOrder = true;
    }

    public void setSaveInSpecifiedOrder() {
        this.saveInOriginalOrder = false;
    }

    public List<String> getAsStringList() {
        ArrayList<String> res = new ArrayList<String>(7);
        if (this.saveInOriginalOrder) {
            res.add(ORIGINAL);
        } else {
            res.add(SPECIFIED);
        }
        res.add(this.sortCriteria[0].field);
        res.add(Boolean.toString(this.sortCriteria[0].descending));
        res.add(this.sortCriteria[1].field);
        res.add(Boolean.toString(this.sortCriteria[1].descending));
        res.add(this.sortCriteria[2].field);
        res.add(Boolean.toString(this.sortCriteria[2].descending));
        return res;
    }

    public static SaveOrderConfig getDefaultSaveOrder() {
        SaveOrderConfig standard = new SaveOrderConfig();
        standard.setSaveInOriginalOrder();
        return standard;
    }

    public static class SortCriterion {
        public String field;
        public boolean descending;

        public SortCriterion() {
            this.field = "";
        }

        public SortCriterion(String field2, String descending) {
            this.field = field2;
            this.descending = Boolean.parseBoolean(descending);
        }

        public SortCriterion(String field2, boolean descending) {
            this.field = field2;
            this.descending = descending;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SortCriterion{");
            sb.append("field='").append(this.field).append('\'');
            sb.append(", descending=").append(this.descending);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortCriterion that = (SortCriterion)o;
            return Objects.equals(this.descending, that.descending) && Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.descending);
        }
    }
}

