/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.importer.fileformat.mods.AbstractDefinition;
import org.jabref.logic.importer.fileformat.mods.CodeOrText;
import org.jabref.logic.importer.fileformat.mods.DateDefinition;
import org.jabref.logic.importer.fileformat.mods.DetailDefinition;
import org.jabref.logic.importer.fileformat.mods.ExtentDefinition;
import org.jabref.logic.importer.fileformat.mods.GenreDefinition;
import org.jabref.logic.importer.fileformat.mods.IdentifierDefinition;
import org.jabref.logic.importer.fileformat.mods.IssuanceDefinition;
import org.jabref.logic.importer.fileformat.mods.LanguageDefinition;
import org.jabref.logic.importer.fileformat.mods.LanguageTermDefinition;
import org.jabref.logic.importer.fileformat.mods.LocationDefinition;
import org.jabref.logic.importer.fileformat.mods.ModsCollectionDefinition;
import org.jabref.logic.importer.fileformat.mods.ModsDefinition;
import org.jabref.logic.importer.fileformat.mods.NameDefinition;
import org.jabref.logic.importer.fileformat.mods.NamePartDefinition;
import org.jabref.logic.importer.fileformat.mods.NoteDefinition;
import org.jabref.logic.importer.fileformat.mods.OriginInfoDefinition;
import org.jabref.logic.importer.fileformat.mods.PartDefinition;
import org.jabref.logic.importer.fileformat.mods.PhysicalLocationDefinition;
import org.jabref.logic.importer.fileformat.mods.PlaceDefinition;
import org.jabref.logic.importer.fileformat.mods.PlaceTermDefinition;
import org.jabref.logic.importer.fileformat.mods.RelatedItemDefinition;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguage;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguagePlusAuthority;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguagePlusSupplied;
import org.jabref.logic.importer.fileformat.mods.SubjectDefinition;
import org.jabref.logic.importer.fileformat.mods.TitleInfoDefinition;
import org.jabref.logic.importer.fileformat.mods.TypeOfResourceDefinition;
import org.jabref.logic.importer.fileformat.mods.UrlDefinition;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

class ModsExporter
extends Exporter {
    protected static final String MODS_NAMESPACE_URI = "http://www.loc.gov/mods/v3";
    private static final String MINUS = "-";
    private static final String DOUBLE_MINUS = "--";
    private static final String MODS_SCHEMA_LOCATION = "http://www.loc.gov/standards/mods/v3/mods-3-6.xsd";
    private JAXBContext context;

    public ModsExporter() {
        super("mods", "MODS", StandardFileType.XML);
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, Charset encoding, List<BibEntry> entries) throws SaveException, IOException {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        try {
            ModsCollectionDefinition modsCollection = new ModsCollectionDefinition();
            for (BibEntry bibEntry : entries) {
                ModsDefinition mods = new ModsDefinition();
                bibEntry.getCiteKeyOptional().ifPresent(citeKey -> this.addIdentifier("citekey", (String)citeKey, mods));
                Map<String, String> fieldMap = bibEntry.getFieldMap();
                this.addGenre(bibEntry, mods);
                OriginInfoDefinition originInfo = new OriginInfoDefinition();
                PartDefinition partDefinition = new PartDefinition();
                RelatedItemDefinition relatedItem = new RelatedItemDefinition();
                for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    switch (key) {
                        case "author": {
                            this.handleAuthors(mods, value);
                            break;
                        }
                        case "affiliation": {
                            this.addAffiliation(mods, value);
                            break;
                        }
                        case "abstract": {
                            this.addAbstract(mods, value);
                            break;
                        }
                        case "title": {
                            this.addTitle(mods, value);
                            break;
                        }
                        case "language": {
                            this.addLanguage(mods, value);
                            break;
                        }
                        case "location": {
                            this.addLocation(mods, value);
                            break;
                        }
                        case "url": {
                            this.addUrl(mods, value);
                            break;
                        }
                        case "note": {
                            this.addNote(mods, value);
                            break;
                        }
                        case "keywords": {
                            this.addKeyWords(mods, value);
                            break;
                        }
                        case "volume": {
                            this.addDetail("volume", value, partDefinition);
                            break;
                        }
                        case "issue": {
                            this.addDetail("issue", value, partDefinition);
                            break;
                        }
                        case "pages": {
                            this.addPages(partDefinition, value);
                            break;
                        }
                        case "uri": {
                            this.addIdentifier("uri", value, mods);
                            break;
                        }
                        case "isbn": {
                            this.addIdentifier("isbn", value, mods);
                            break;
                        }
                        case "issn": {
                            this.addIdentifier("issn", value, mods);
                            break;
                        }
                        case "doi": {
                            this.addIdentifier("doi", value, mods);
                            break;
                        }
                        case "pmid": {
                            this.addIdentifier("pmid", value, mods);
                            break;
                        }
                        case "journal": {
                            this.addJournal(value, relatedItem);
                            break;
                        }
                    }
                    this.addOriginInformation(key, value, originInfo);
                }
                mods.getModsGroup().add(originInfo);
                this.addRelatedAndOriginInfoToModsGroup(relatedItem, partDefinition, mods);
                modsCollection.getMods().add(mods);
            }
            JAXBElement jaxbElement = new JAXBElement(new QName(MODS_NAMESPACE_URI, "modsCollection"), ModsCollectionDefinition.class, (Object)modsCollection);
            this.createMarshallerAndWriteToFile(file, (JAXBElement<ModsCollectionDefinition>)jaxbElement);
        }
        catch (JAXBException ex) {
            throw new SaveException(ex);
        }
    }

    private void createMarshallerAndWriteToFile(Path file, JAXBElement<ModsCollectionDefinition> jaxbElement) throws JAXBException {
        if (this.context == null) {
            this.context = JAXBContext.newInstance((Class[])new Class[]{ModsCollectionDefinition.class});
        }
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", (Object)MODS_SCHEMA_LOCATION);
        marshaller.marshal(jaxbElement, file.toFile());
    }

    private void addRelatedAndOriginInfoToModsGroup(RelatedItemDefinition relatedItem, PartDefinition partDefinition, ModsDefinition mods) {
        relatedItem.getModsGroup().add(partDefinition);
        relatedItem.setAtType("host");
        mods.getModsGroup().add(relatedItem);
        TypeOfResourceDefinition typeOfResource = new TypeOfResourceDefinition();
        typeOfResource.setValue("text");
        mods.getModsGroup().add(typeOfResource);
    }

    private void addGenre(BibEntry bibEntry, ModsDefinition mods) {
        GenreDefinition genre = new GenreDefinition();
        genre.setValue(bibEntry.getType());
        mods.getModsGroup().add(genre);
    }

    private void addAbstract(ModsDefinition mods, String value) {
        AbstractDefinition abstractDefinition = new AbstractDefinition();
        abstractDefinition.setValue(value);
        mods.getModsGroup().add(abstractDefinition);
    }

    private void addTitle(ModsDefinition mods, String value) {
        TitleInfoDefinition titleInfo = new TitleInfoDefinition();
        StringPlusLanguage title = new StringPlusLanguage();
        title.setValue(value);
        JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "title"), StringPlusLanguage.class, (Object)title);
        titleInfo.getTitleOrSubTitleOrPartNumber().add(element);
        mods.getModsGroup().add(titleInfo);
    }

    private void addAffiliation(ModsDefinition mods, String value) {
        NameDefinition nameDefinition = new NameDefinition();
        StringPlusLanguage affiliation = new StringPlusLanguage();
        affiliation.setValue(value);
        JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "affiliation"), StringPlusLanguage.class, (Object)affiliation);
        nameDefinition.getAffiliationOrRoleOrDescription().add(element);
        mods.getModsGroup().add(nameDefinition);
    }

    private void addLocation(ModsDefinition mods, String value) {
        String[] locations;
        LocationDefinition locationDefinition = new LocationDefinition();
        for (String location : locations = value.split(", ")) {
            PhysicalLocationDefinition physicalLocation = new PhysicalLocationDefinition();
            physicalLocation.setValue(location);
            locationDefinition.getPhysicalLocation().add(physicalLocation);
        }
        mods.getModsGroup().add(locationDefinition);
    }

    private void addNote(ModsDefinition mods, String value) {
        String[] notes;
        for (String note : notes = value.split(", ")) {
            NoteDefinition noteDefinition = new NoteDefinition();
            noteDefinition.setValue(note);
            mods.getModsGroup().add(noteDefinition);
        }
    }

    private void addUrl(ModsDefinition mods, String value) {
        String[] urls = value.split(", ");
        LocationDefinition location = new LocationDefinition();
        for (String url : urls) {
            UrlDefinition urlDefinition = new UrlDefinition();
            urlDefinition.setValue(url);
            location.getUrl().add(urlDefinition);
            mods.getModsGroup().add(location);
        }
    }

    private void addJournal(String value, RelatedItemDefinition relatedItem) {
        TitleInfoDefinition titleInfo = new TitleInfoDefinition();
        StringPlusLanguage title = new StringPlusLanguage();
        title.setValue(value);
        JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "title"), StringPlusLanguage.class, (Object)title);
        titleInfo.getTitleOrSubTitleOrPartNumber().add(element);
        relatedItem.getModsGroup().add(titleInfo);
    }

    private void addLanguage(ModsDefinition mods, String value) {
        LanguageDefinition language2 = new LanguageDefinition();
        LanguageTermDefinition languageTerm = new LanguageTermDefinition();
        languageTerm.setValue(value);
        language2.getLanguageTerm().add(languageTerm);
        mods.getModsGroup().add(language2);
    }

    private void addPages(PartDefinition partDefinition, String value) {
        if (value.contains(DOUBLE_MINUS)) {
            this.addStartAndEndPage(value, partDefinition, DOUBLE_MINUS);
        } else if (value.contains(MINUS)) {
            this.addStartAndEndPage(value, partDefinition, MINUS);
        } else {
            BigInteger total = new BigInteger(value);
            ExtentDefinition extent = new ExtentDefinition();
            extent.setTotal(total);
            partDefinition.getDetailOrExtentOrDate().add(extent);
        }
    }

    private void addKeyWords(ModsDefinition mods, String value) {
        String[] keywords;
        for (String keyword : keywords = value.split(", ")) {
            SubjectDefinition subject = new SubjectDefinition();
            StringPlusLanguagePlusAuthority topic = new StringPlusLanguagePlusAuthority();
            topic.setValue(keyword);
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "topic"), StringPlusLanguagePlusAuthority.class, (Object)topic);
            subject.getTopicOrGeographicOrTemporal().add(element);
            mods.getModsGroup().add(subject);
        }
    }

    private void handleAuthors(ModsDefinition mods, String value) {
        String[] authors;
        for (String author : authors = value.split("and")) {
            NameDefinition name = new NameDefinition();
            name.setAtType("personal");
            NamePartDefinition namePart = new NamePartDefinition();
            if (author.contains(",")) {
                String[] forenames;
                int commaIndex = author.indexOf(44);
                String familyName = author.substring(0, commaIndex);
                namePart.setAtType("family");
                namePart.setValue(familyName);
                JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "namePart"), NamePartDefinition.class, (Object)namePart);
                name.getNamePartOrDisplayFormOrAffiliation().add(element);
                String forename = author.substring(commaIndex + 1, author.length());
                for (String given : forenames = forename.split(" ")) {
                    if (given.isEmpty()) continue;
                    NamePartDefinition namePartDefinition = new NamePartDefinition();
                    namePartDefinition.setAtType("given");
                    namePartDefinition.setValue(given);
                    element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "namePart"), NamePartDefinition.class, (Object)namePartDefinition);
                    name.getNamePartOrDisplayFormOrAffiliation().add(element);
                }
                mods.getModsGroup().add(name);
                continue;
            }
            namePart.setAtType("family");
            namePart.setValue(author);
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "namePart"), NamePartDefinition.class, (Object)namePart);
            name.getNamePartOrDisplayFormOrAffiliation().add(element);
            mods.getModsGroup().add(name);
        }
    }

    private void addIdentifier(String key, String value, ModsDefinition mods) {
        if ("citekey".equals(key)) {
            mods.setID(value);
        }
        IdentifierDefinition identifier = new IdentifierDefinition();
        identifier.setType(key);
        identifier.setValue(value);
        mods.getModsGroup().add(identifier);
    }

    private void addStartAndEndPage(String value, PartDefinition partDefinition, String minus) {
        int minusIndex = value.indexOf(minus);
        String startPage = value.substring(0, minusIndex);
        String endPage = "";
        if (MINUS.equals(minus)) {
            endPage = value.substring(minusIndex + 1);
        } else if (DOUBLE_MINUS.equals(minus)) {
            endPage = value.substring(minusIndex + 2);
        }
        StringPlusLanguage start = new StringPlusLanguage();
        start.setValue(startPage);
        StringPlusLanguage end = new StringPlusLanguage();
        end.setValue(endPage);
        ExtentDefinition extent = new ExtentDefinition();
        extent.setStart(start);
        extent.setEnd(end);
        partDefinition.getDetailOrExtentOrDate().add(extent);
    }

    private void addDetail(String detailName, String value, PartDefinition partDefinition) {
        DetailDefinition detail = new DetailDefinition();
        StringPlusLanguage detailType = new StringPlusLanguage();
        detailType.setValue(value);
        detail.setType(detailName);
        JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "number"), StringPlusLanguage.class, (Object)detailType);
        detail.getNumberOrCaptionOrTitle().add((JAXBElement<StringPlusLanguage>)element);
        partDefinition.getDetailOrExtentOrDate().add(detail);
    }

    private void addOriginInformation(String key, String value, OriginInfoDefinition originInfo) {
        if ("year".equals(key)) {
            this.addDate("dateIssued", value, originInfo);
        } else if ("created".equals(key)) {
            this.addDate("dateCreated", value, originInfo);
        } else if ("modified".equals(key)) {
            this.addDate("dateModified", value, originInfo);
        } else if ("captured".equals(key)) {
            this.addDate("dateCaptured", value, originInfo);
        } else if ("publisher".equals(key)) {
            StringPlusLanguagePlusSupplied publisher = new StringPlusLanguagePlusSupplied();
            publisher.setValue(value);
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "publisher"), StringPlusLanguagePlusSupplied.class, (Object)publisher);
            originInfo.getPlaceOrPublisherOrDateIssued().add(element);
        } else if ("issuance".equals(key)) {
            IssuanceDefinition issuance = IssuanceDefinition.fromValue(value);
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "issuance"), IssuanceDefinition.class, (Object)issuance);
            originInfo.getPlaceOrPublisherOrDateIssued().add(element);
        } else if ("address".equals(key)) {
            String[] places;
            PlaceDefinition placeDefinition = new PlaceDefinition();
            for (String place : places = value.split(", ")) {
                PlaceTermDefinition placeTerm = new PlaceTermDefinition();
                placeTerm.setType(CodeOrText.TEXT);
                placeTerm.setValue(place);
                placeDefinition.getPlaceTerm().add(placeTerm);
            }
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "place"), PlaceDefinition.class, (Object)placeDefinition);
            originInfo.getPlaceOrPublisherOrDateIssued().add(element);
        } else if ("edition".equals(key)) {
            StringPlusLanguagePlusSupplied edition = new StringPlusLanguagePlusSupplied();
            edition.setValue(value);
            JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, "edition"), StringPlusLanguagePlusSupplied.class, (Object)edition);
            originInfo.getPlaceOrPublisherOrDateIssued().add(element);
        }
    }

    private void addDate(String dateName, String value, OriginInfoDefinition originInfo) {
        DateDefinition dateIssued = new DateDefinition();
        dateIssued.setKeyDate("yes");
        dateIssued.setValue(value);
        JAXBElement element = new JAXBElement(new QName(MODS_NAMESPACE_URI, dateName), DateDefinition.class, (Object)dateIssued);
        originInfo.getPlaceOrPublisherOrDateIssued().add(element);
    }
}

