/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class DirectoryDialogConfiguration {
    private final Path initialDirectory;

    private DirectoryDialogConfiguration(Path initialDirectory) {
        this.initialDirectory = initialDirectory;
    }

    public Optional<Path> getInitialDirectory() {
        return Optional.ofNullable(this.initialDirectory);
    }

    public static class Builder {
        private Path initialDirectory;

        public DirectoryDialogConfiguration build() {
            return new DirectoryDialogConfiguration(this.initialDirectory);
        }

        public Builder withInitialDirectory(Path directory) {
            if (!Files.isDirectory(directory = directory.toAbsolutePath(), new LinkOption[0])) {
                directory = directory.getParent();
            }
            if (!Files.exists(directory, new LinkOption[0])) {
                directory = null;
            }
            this.initialDirectory = directory;
            return this;
        }

        public Builder withInitialDirectory(String directory) {
            this.withInitialDirectory(Paths.get(directory, new String[0]));
            return this;
        }
    }
}

