/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.BasePanel;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoableInsertEntry
extends AbstractUndoableJabRefEdit {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoableInsertEntry.class);
    private final BibDatabase base;
    private final BibEntry entry;
    private final BasePanel panel;

    public UndoableInsertEntry(BibDatabase base, BibEntry entry, BasePanel panel) {
        this.base = base;
        this.entry = entry;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("insert entry %0", StringUtil.boldHTML(this.entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.removeEntry(this.entry);
            this.panel.ensureNotShowingBottomPanel(this.entry);
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem to undo `insert entry`", ex);
        }
    }

    @Override
    public void redo() {
        super.redo();
        this.base.insertEntry(this.entry);
    }
}

