/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.jabref.gui.groups.GroupMatcher;
import org.jabref.gui.maintable.ListSynchronizer;
import org.jabref.gui.search.HitOrMissComparator;
import org.jabref.gui.search.matchers.EverythingMatcher;
import org.jabref.gui.search.matchers.SearchMatcher;
import org.jabref.gui.util.comparator.IsMarkedComparator;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public class MainTableDataModel {
    private final ListSynchronizer listSynchronizer;
    private final SortedList<BibEntry> sortedForUserDefinedTableColumnSorting;
    private final SortedList<BibEntry> sortedForMarkingSearchGrouping;
    private final StartStopListFilterAction filterSearchToggle;
    private final StartStopListFilterAction filterGroupToggle;
    private final EventList<BibEntry> finalList;
    private final FilterAndSortingState filterAndSortingState = new FilterAndSortingState();

    public MainTableDataModel(BibDatabaseContext context) {
        ObservableList<BibEntry> entries = context.getDatabase().getEntries();
        BasicEventList<BibEntry> initialEventList = new BasicEventList<BibEntry>();
        initialEventList.addAll((Collection<BibEntry>)entries);
        this.listSynchronizer = new ListSynchronizer(initialEventList);
        this.sortedForUserDefinedTableColumnSorting = new SortedList<BibEntry>(initialEventList, null);
        this.sortedForMarkingSearchGrouping = new SortedList<BibEntry>(this.sortedForUserDefinedTableColumnSorting, null);
        FilterList<BibEntry> groupFilterList = new FilterList<BibEntry>(this.sortedForMarkingSearchGrouping, EverythingMatcher.INSTANCE);
        this.filterGroupToggle = new StartStopListFilterAction(groupFilterList, GroupMatcher.INSTANCE, EverythingMatcher.INSTANCE);
        FilterList<BibEntry> searchFilterList = new FilterList<BibEntry>(groupFilterList, EverythingMatcher.INSTANCE);
        this.filterSearchToggle = new StartStopListFilterAction(searchFilterList, SearchMatcher.INSTANCE, EverythingMatcher.INSTANCE);
        this.finalList = searchFilterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSortOrder() {
        Comparator<BibEntry> markingComparator = this.filterAndSortingState.markingState ? IsMarkedComparator.INSTANCE : null;
        HitOrMissComparator searchComparator = this.getSearchState() == DisplayOption.FLOAT ? new HitOrMissComparator(SearchMatcher.INSTANCE) : null;
        HitOrMissComparator groupingComparator = this.getGroupingState() == DisplayOption.FLOAT ? new HitOrMissComparator(GroupMatcher.INSTANCE) : null;
        GenericCompositeComparator comparator = new GenericCompositeComparator(markingComparator, searchComparator, groupingComparator);
        this.sortedForMarkingSearchGrouping.getReadWriteLock().writeLock().lock();
        try {
            if (this.sortedForMarkingSearchGrouping.getComparator() != comparator) {
                this.sortedForMarkingSearchGrouping.setComparator(comparator);
            }
        }
        finally {
            this.sortedForMarkingSearchGrouping.getReadWriteLock().writeLock().unlock();
        }
    }

    public void updateSearchState(DisplayOption searchState) {
        Objects.requireNonNull(searchState);
        if (this.filterAndSortingState.searchState == searchState) {
            return;
        }
        boolean updateSortOrder = false;
        if (this.filterAndSortingState.searchState == DisplayOption.FLOAT) {
            updateSortOrder = true;
        } else if (this.filterAndSortingState.searchState == DisplayOption.FILTER) {
            this.filterSearchToggle.stop();
        }
        if (searchState == DisplayOption.FLOAT) {
            updateSortOrder = true;
        } else if (searchState == DisplayOption.FILTER) {
            this.filterSearchToggle.start();
        }
        this.filterAndSortingState.searchState = searchState;
        if (updateSortOrder) {
            this.updateSortOrder();
        }
    }

    public void updateGroupingState(DisplayOption groupingState) {
        Objects.requireNonNull(groupingState);
        if (this.filterAndSortingState.groupingState == groupingState) {
            return;
        }
        boolean updateSortOrder = false;
        if (this.filterAndSortingState.groupingState == DisplayOption.FLOAT) {
            updateSortOrder = true;
        } else if (this.filterAndSortingState.groupingState == DisplayOption.FILTER) {
            this.filterGroupToggle.stop();
        }
        if (groupingState == DisplayOption.FLOAT) {
            updateSortOrder = true;
        } else if (groupingState == DisplayOption.FILTER) {
            this.filterGroupToggle.start();
        }
        this.filterAndSortingState.groupingState = groupingState;
        if (updateSortOrder) {
            this.updateSortOrder();
        }
    }

    public DisplayOption getSearchState() {
        return this.filterAndSortingState.searchState;
    }

    DisplayOption getGroupingState() {
        return this.filterAndSortingState.groupingState;
    }

    public ListSynchronizer getListSynchronizer() {
        return this.listSynchronizer;
    }

    public void updateMarkingState(boolean floatMarkedEntries) {
        if (this.filterAndSortingState.markingState == floatMarkedEntries) {
            return;
        }
        if (floatMarkedEntries) {
            this.filterAndSortingState.markingState = true;
        } else {
            this.filterAndSortingState.markingState = false;
        }
        this.updateSortOrder();
    }

    EventList<BibEntry> getTableRows() {
        return this.finalList;
    }

    SortedList<BibEntry> getSortedForUserDefinedTableColumnSorting() {
        return this.sortedForUserDefinedTableColumnSorting;
    }

    public void updateGroupFilter() {
        if (this.getGroupingState() == DisplayOption.FILTER) {
            this.filterGroupToggle.start();
        } else {
            this.filterGroupToggle.stop();
        }
    }

    private static class StartStopListFilterAction {
        private final Matcher<BibEntry> active;
        private final Matcher<BibEntry> inactive;
        private final FilterList<BibEntry> list;

        private StartStopListFilterAction(FilterList<BibEntry> list, Matcher<BibEntry> active, Matcher<BibEntry> inactive) {
            this.list = list;
            this.active = active;
            this.inactive = inactive;
            list.setMatcher(inactive);
        }

        public void start() {
            this.update(this.active);
        }

        public void stop() {
            this.update(this.inactive);
        }

        private void update(Matcher<BibEntry> comparator) {
            this.list.getReadWriteLock().writeLock().lock();
            try {
                this.list.setMatcher(comparator);
            }
            finally {
                this.list.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private static class GenericCompositeComparator
    implements Comparator<BibEntry> {
        private final List<Comparator<BibEntry>> comparators;

        @SafeVarargs
        public GenericCompositeComparator(Comparator<BibEntry> ... comparators) {
            this.comparators = Arrays.asList(comparators).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public int compare(BibEntry lhs, BibEntry rhs) {
            for (Comparator<BibEntry> comp : this.comparators) {
                int result = comp.compare(lhs, rhs);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    static class FilterAndSortingState {
        private DisplayOption searchState = DisplayOption.DISABLED;
        private DisplayOption groupingState = DisplayOption.DISABLED;
        private boolean markingState = false;

        FilterAndSortingState() {
        }
    }

    public static enum DisplayOption {
        FLOAT,
        FILTER,
        DISABLED;

    }
}

