/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import org.jabref.gui.actions.CopyDoiUrlAction;
import org.jabref.gui.fieldeditors.contextmenu.CaseChangeMenu;
import org.jabref.gui.fieldeditors.contextmenu.ClearField;
import org.jabref.gui.fieldeditors.contextmenu.ConversionMenu;
import org.jabref.gui.fieldeditors.contextmenu.ProtectedTermsMenu;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.l10n.Localization;

public class EditorMenus {
    public static Supplier<List<MenuItem>> getDefaultMenu(TextArea textArea) {
        return () -> {
            ArrayList<Object> menuItems = new ArrayList<Object>(6);
            menuItems.add((Object)new CaseChangeMenu(textArea.textProperty()));
            menuItems.add((Object)new ConversionMenu(textArea.textProperty()));
            menuItems.add(new SeparatorMenuItem());
            menuItems.add((Object)new ProtectedTermsMenu(textArea));
            menuItems.add(new SeparatorMenuItem());
            menuItems.add((Object)new ClearField(textArea));
            return menuItems;
        };
    }

    public static Supplier<List<MenuItem>> getNameMenu(TextArea textArea) {
        return () -> {
            CustomMenuItem normalizeNames = new CustomMenuItem((Node)new Label(Localization.lang("Normalize to BibTeX name format", new String[0])));
            normalizeNames.setOnAction(event -> textArea.setText(new NormalizeNamesFormatter().format(textArea.getText())));
            Tooltip toolTip = new Tooltip(Localization.lang("If possible, normalize this list of names to conform to standard BibTeX name formatting", new String[0]));
            Tooltip.install((Node)normalizeNames.getContent(), (Tooltip)toolTip);
            ArrayList<CustomMenuItem> menuItems = new ArrayList<CustomMenuItem>(6);
            menuItems.add(normalizeNames);
            menuItems.addAll((Collection)EditorMenus.getDefaultMenu(textArea).get());
            return menuItems;
        };
    }

    public static Supplier<List<MenuItem>> getDOIMenu(TextArea textArea) {
        return () -> {
            CopyDoiUrlAction copyDoiUrlAction = new CopyDoiUrlAction(textArea);
            MenuItem copyDoiUrlMenuItem = new MenuItem((String)copyDoiUrlAction.getValue("Name"));
            copyDoiUrlMenuItem.setOnAction(event -> copyDoiUrlAction.actionPerformed(null));
            ArrayList<Object> menuItems = new ArrayList<Object>();
            menuItems.add(copyDoiUrlMenuItem);
            menuItems.add(new SeparatorMenuItem());
            menuItems.addAll((Collection)EditorMenus.getDefaultMenu(textArea).get());
            return menuItems;
        };
    }
}

