/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.auximport.FromAuxDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.Defaults;
import org.jabref.model.database.BibDatabaseContext;

public class NewSubDatabaseAction
extends MnemonicAwareAction {
    private final JabRefFrame jabRefFrame;

    public NewSubDatabaseAction(JabRefFrame jabRefFrame) {
        super(IconTheme.JabRefIcon.NEW.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", Localization.menuTitle("New sublibrary based on AUX file", new String[0]) + "...");
        this.putValue("ShortDescription", Localization.lang("New BibTeX sublibrary", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FromAuxDialog dialog = new FromAuxDialog(this.jabRefFrame, "", true, this.jabRefFrame.getTabbedPane());
        dialog.setLocationRelativeTo(this.jabRefFrame);
        dialog.setVisible(true);
        if (dialog.generatePressed()) {
            Defaults defaults = new Defaults(Globals.prefs.getDefaultBibDatabaseMode());
            BasePanel bp = new BasePanel(this.jabRefFrame, new BibDatabaseContext(dialog.getGenerateDB(), defaults));
            this.jabRefFrame.addTab(bp, true);
            this.jabRefFrame.output(Localization.lang("New library created.", new String[0]));
        }
    }
}

